/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.ReferenceDefinition;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public final class Reference
extends Link {
    private final String[] referenceNames;

    public Reference(String[] referenceNames) {
        this(referenceNames, null);
    }

    public Reference(String[] referenceNames, String[] propositionIds) {
        this(referenceNames, propositionIds, null);
    }

    public Reference(String[] referenceNames, String[] propositionIds, PropertyConstraint[] constraints) {
        this(referenceNames, propositionIds, constraints, null, -1, -1);
    }

    public Reference(String[] referenceNames, String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int index) {
        this(referenceNames, propositionIds, constraints, comparator, index, index >= 0 ? index + 1 : -1);
    }

    public Reference(String[] referenceNames, String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int fromIndex, int toIndex) {
        super(propositionIds, constraints, comparator, fromIndex, toIndex);
        if (referenceNames != null) {
            ProtempaUtil.checkArrayForNullElement(referenceNames, "referenceNames");
            String[] refNames = (String[])referenceNames.clone();
            for (int i = 0; i < refNames.length; ++i) {
                refNames[i] = refNames[i].intern();
            }
            this.referenceNames = refNames;
        } else {
            this.referenceNames = ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    public Reference(String referenceName) {
        this(referenceName, null);
    }

    public Reference(String referenceName, String[] propositionIds) {
        this(referenceName, propositionIds, null);
    }

    public Reference(String referenceName, String[] propositionIds, PropertyConstraint[] constraints) {
        this(referenceName, propositionIds, constraints, null, -1, -1);
    }

    public Reference(String referenceName, String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int index) {
        this(referenceName, propositionIds, constraints, comparator, index, index >= 0 ? index + 1 : -1);
    }

    public Reference(String referenceName, String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int fromIndex, int toIndex) {
        super(propositionIds, constraints, comparator, fromIndex, toIndex);
        if (referenceName == null) {
            throw new IllegalArgumentException("referenceName cannot be null");
        }
        this.referenceNames = new String[]{referenceName.intern()};
    }

    public String[] getReferenceNames() {
        if (this.referenceNames != null) {
            return (String[])this.referenceNames.clone();
        }
        return this.referenceNames;
    }

    @Override
    String headerFragment() {
        String references = StringUtils.join((Object[])this.referenceNames, (char)',');
        return this.createHeaderFragment(references);
    }

    @Override
    Collection<Proposition> traverse(Proposition proposition, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache, Set<Proposition> cache) {
        String[] refNames;
        ArrayList<Proposition> props = new ArrayList<Proposition>();
        for (String referenceName : refNames = this.referenceNames.length > 0 ? this.referenceNames : proposition.getReferenceNames()) {
            List<UniqueId> uids = proposition.getReferences(referenceName);
            for (UniqueId uid : uids) {
                Proposition prop = references.get(uid);
                if (prop == null || !cache.add(prop) || !this.isMatch(prop)) continue;
                props.add(prop);
            }
        }
        return this.createResults(props);
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        String[] explicitPropIds = this.getPropositionIds();
        if (explicitPropIds.length > 0) {
            return (String[])explicitPropIds.clone();
        }
        HashSet result = new HashSet();
        for (PropositionDefinition propDef : knowledgeSource.readPropositionDefinitions(inPropIds)) {
            for (String refName : this.referenceNames) {
                ReferenceDefinition refDef = propDef.referenceDefinition(refName);
                if (refDef == null) continue;
                org.arp.javautil.arrays.Arrays.addAll(result, (Object[][])new String[][]{refDef.getPropositionIds()});
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.referenceNames);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        return Arrays.equals(this.referenceNames, other.referenceNames);
    }
}

