/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.ProtempaException;
import org.protempa.proposition.TemporalParameter;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.visitor.PropositionCheckedVisitor;
import org.protempa.proposition.visitor.PropositionVisitor;

public final class AbstractParameter
extends TemporalParameter
implements Serializable {
    private static final long serialVersionUID = -137441242472941229L;
    private String contextId;

    public AbstractParameter(String id, UniqueId uniqueId) {
        super(id, uniqueId);
    }

    @Override
    public void setInterval(Interval interval) {
        super.setInterval(interval);
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @Override
    public boolean isEqual(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractParameter)) {
            return false;
        }
        AbstractParameter a = (AbstractParameter)o;
        Granularity startGranularity = this.getInterval().getStartGranularity();
        Granularity aStartGranularity = a.getInterval().getStartGranularity();
        Granularity finishGranularity = this.getInterval().getFinishGranularity();
        Granularity aFinishGranularity = a.getInterval().getFinishGranularity();
        return super.isEqual(a) && (startGranularity == aStartGranularity || startGranularity != null && startGranularity.equals(aStartGranularity)) && (finishGranularity == aFinishGranularity || finishGranularity != null && finishGranularity.equals(aFinishGranularity)) && (this.contextId == a.contextId || this.contextId != null && this.contextId.equals(a.contextId));
    }

    @Override
    public void accept(PropositionVisitor propositionVisitor) {
        propositionVisitor.visit(this);
    }

    @Override
    public void acceptChecked(PropositionCheckedVisitor propositionCheckedVisitor) throws ProtempaException {
        propositionCheckedVisitor.visit(this);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeAbstractProposition(s);
        this.writeTemporalProposition(s);
        this.writeTemporalParameter(s);
        s.writeObject(this.contextId);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readAbstractProposition(s);
        this.readTemporalProposition(s);
        this.readTemporalParameter(s);
        this.contextId = (String)s.readObject();
    }
}

