/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protempa.SourceSystem;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;

public final class CopyPropositionVisitor
extends AbstractPropositionVisitor {
    private Proposition theCopy;
    private Map<String, Value> properties;
    private Map<String, List<UniqueId>> references;
    private UniqueId uniqueId;
    private SourceSystem sourceSystem;
    private Date downloadDate;
    private Date createDate;
    private Date updateDate;
    private Date deleteDate;

    public Map<String, Value> getProperties() {
        return new HashMap<String, Value>(this.properties);
    }

    public void setProperties(Map<String, Value> properties) {
        this.properties = properties != null ? new HashMap<String, Value>(properties) : null;
    }

    public Map<String, List<UniqueId>> getReferences() {
        return new HashMap<String, List<UniqueId>>(this.references);
    }

    public void setReferences(Map<String, List<UniqueId>> references) {
        this.references = references != null ? new HashMap<String, List<UniqueId>>(references) : null;
    }

    public UniqueId getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(UniqueId uniqueId) {
        this.uniqueId = uniqueId;
    }

    public SourceSystem getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(SourceSystem sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public Date getDownloadDate() {
        return this.downloadDate;
    }

    public void setDownloadDate(Date downloadDate) {
        this.downloadDate = downloadDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    @Override
    public void visit(Context context) {
        Context copy = new Context(context.getId(), this.uniqueId != null ? this.uniqueId : context.getUniqueId());
        copy.setCreateDate(this.createDate != null ? this.createDate : context.getCreateDate());
        copy.setUpdateDate(this.updateDate != null ? this.updateDate : context.getUpdateDate());
        copy.setDeleteDate(this.deleteDate != null ? this.deleteDate : context.getDeleteDate());
        copy.setDownloadDate(this.downloadDate != null ? this.downloadDate : context.getDownloadDate());
        copy.setInterval(context.getInterval());
        copy.setSourceSystem(this.sourceSystem != null ? this.sourceSystem : context.getSourceSystem());
        if (this.references != null) {
            for (String refName : this.references.keySet()) {
                copy.setReferences(refName, this.references.get(refName));
            }
        } else {
            for (String refName : context.getReferenceNames()) {
                copy.setReferences(refName, context.getReferences(refName));
            }
        }
        if (this.properties != null) {
            for (String propName : this.properties.keySet()) {
                copy.setProperty(propName, this.properties.get(propName));
            }
        } else {
            for (String propName : context.getPropertyNames()) {
                copy.setProperty(propName, context.getProperty(propName));
            }
        }
        this.theCopy = copy;
    }

    @Override
    public void visit(Constant constant) {
        Constant copy = new Constant(constant.getId(), this.uniqueId != null ? this.uniqueId : constant.getUniqueId());
        copy.setCreateDate(this.createDate != null ? this.createDate : constant.getCreateDate());
        copy.setUpdateDate(this.updateDate != null ? this.updateDate : constant.getUpdateDate());
        copy.setDeleteDate(this.deleteDate != null ? this.deleteDate : constant.getDeleteDate());
        copy.setDownloadDate(this.downloadDate != null ? this.downloadDate : constant.getDownloadDate());
        copy.setSourceSystem(this.sourceSystem != null ? this.sourceSystem : constant.getSourceSystem());
        if (this.references != null) {
            for (String refName : this.references.keySet()) {
                copy.setReferences(refName, this.references.get(refName));
            }
        } else {
            for (String refName : constant.getReferenceNames()) {
                copy.setReferences(refName, constant.getReferences(refName));
            }
        }
        if (this.properties != null) {
            for (String propName : this.properties.keySet()) {
                copy.setProperty(propName, this.properties.get(propName));
            }
        } else {
            for (String propName : constant.getPropertyNames()) {
                copy.setProperty(propName, constant.getProperty(propName));
            }
        }
        this.theCopy = copy;
    }

    @Override
    public void visit(PrimitiveParameter primitiveParameter) {
        PrimitiveParameter copy = new PrimitiveParameter(primitiveParameter.getId(), this.uniqueId != null ? this.uniqueId : primitiveParameter.getUniqueId());
        copy.setCreateDate(this.createDate != null ? this.createDate : primitiveParameter.getCreateDate());
        copy.setUpdateDate(this.updateDate != null ? this.updateDate : primitiveParameter.getUpdateDate());
        copy.setDeleteDate(this.deleteDate != null ? this.deleteDate : primitiveParameter.getDeleteDate());
        copy.setDownloadDate(this.downloadDate != null ? this.downloadDate : primitiveParameter.getDownloadDate());
        copy.setInterval(primitiveParameter.getInterval());
        copy.setSourceSystem(this.sourceSystem != null ? this.sourceSystem : primitiveParameter.getSourceSystem());
        if (this.references != null) {
            for (String refName : this.references.keySet()) {
                copy.setReferences(refName, this.references.get(refName));
            }
        } else {
            for (String refName : primitiveParameter.getReferenceNames()) {
                copy.setReferences(refName, primitiveParameter.getReferences(refName));
            }
        }
        if (this.properties != null) {
            for (String propName : this.properties.keySet()) {
                copy.setProperty(propName, this.properties.get(propName));
            }
        } else {
            for (String propName : primitiveParameter.getPropertyNames()) {
                copy.setProperty(propName, primitiveParameter.getProperty(propName));
            }
        }
        copy.setValue(primitiveParameter.getValue());
        this.theCopy = copy;
    }

    @Override
    public void visit(Event event) {
        Event copy = new Event(event.getId(), this.uniqueId != null ? this.uniqueId : event.getUniqueId());
        copy.setCreateDate(this.createDate != null ? this.createDate : event.getCreateDate());
        copy.setUpdateDate(this.updateDate != null ? this.updateDate : event.getUpdateDate());
        copy.setDeleteDate(this.deleteDate != null ? this.deleteDate : event.getDeleteDate());
        copy.setDownloadDate(this.downloadDate != null ? this.downloadDate : event.getDownloadDate());
        copy.setInterval(event.getInterval());
        copy.setSourceSystem(this.sourceSystem != null ? this.sourceSystem : event.getSourceSystem());
        if (this.references != null) {
            for (String refName : this.references.keySet()) {
                copy.setReferences(refName, this.references.get(refName));
            }
        } else {
            for (String refName : event.getReferenceNames()) {
                copy.setReferences(refName, event.getReferences(refName));
            }
        }
        if (this.properties != null) {
            for (String propName : this.properties.keySet()) {
                copy.setProperty(propName, this.properties.get(propName));
            }
        } else {
            for (String propName : event.getPropertyNames()) {
                copy.setProperty(propName, event.getProperty(propName));
            }
        }
        this.theCopy = copy;
    }

    @Override
    public void visit(AbstractParameter abstractParameter) {
        AbstractParameter copy = new AbstractParameter(abstractParameter.getId(), this.uniqueId != null ? this.uniqueId : abstractParameter.getUniqueId());
        copy.setCreateDate(this.createDate != null ? this.createDate : abstractParameter.getCreateDate());
        copy.setUpdateDate(this.updateDate != null ? this.updateDate : abstractParameter.getUpdateDate());
        copy.setDeleteDate(this.deleteDate != null ? this.deleteDate : abstractParameter.getDeleteDate());
        copy.setDownloadDate(this.downloadDate != null ? this.downloadDate : abstractParameter.getDownloadDate());
        copy.setInterval(abstractParameter.getInterval());
        copy.setSourceSystem(this.sourceSystem != null ? this.sourceSystem : abstractParameter.getSourceSystem());
        if (this.references != null) {
            for (String refName : this.references.keySet()) {
                copy.setReferences(refName, this.references.get(refName));
            }
        } else {
            for (String refName : abstractParameter.getReferenceNames()) {
                copy.setReferences(refName, abstractParameter.getReferences(refName));
            }
        }
        if (this.properties != null) {
            for (String propName : this.properties.keySet()) {
                copy.setProperty(propName, this.properties.get(propName));
            }
        } else {
            for (String propName : abstractParameter.getPropertyNames()) {
                copy.setProperty(propName, abstractParameter.getProperty(propName));
            }
        }
        copy.setValue(abstractParameter.getValue());
        this.theCopy = copy;
    }

    public Proposition getCopy() {
        return this.theCopy;
    }

    public void clear() {
        this.theCopy = null;
    }
}

