/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.util.Date;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.Granularity;

public class AbsoluteTimeIntervalFactory {
    private IntervalFactory factory = new IntervalFactory();

    public Interval getInstance() {
        return this.factory.getInstance();
    }

    public Interval getInstance(Date date, Granularity gran) {
        Long dateAsPos = AbsoluteTimeGranularityUtil.asPosition(date);
        return this.factory.getInstance(dateAsPos, gran);
    }

    public Interval getInstance(Date start, Granularity startGran, Date finish, Granularity finishGran) {
        Long startAsPos = AbsoluteTimeGranularityUtil.asPosition(start);
        Long finishAsPos = AbsoluteTimeGranularityUtil.asPosition(finish);
        return this.factory.getInstance(startAsPos, startGran, finishAsPos, finishGran);
    }

    public Interval getInstance(Date minStart, Date maxStart, Granularity startGran, Date minFinish, Date maxFinish, Granularity finishGran) {
        Long minStartAsPos = AbsoluteTimeGranularityUtil.asPosition(minStart);
        Long maxStartAsPos = AbsoluteTimeGranularityUtil.asPosition(maxStart);
        Long minFinishAsPos = AbsoluteTimeGranularityUtil.asPosition(minFinish);
        Long maxFinishAsPos = AbsoluteTimeGranularityUtil.asPosition(maxFinish);
        return this.factory.getInstance(minStartAsPos, maxStartAsPos, startGran, minFinishAsPos, maxFinishAsPos, finishGran);
    }
}

