/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.util.ResourceBundle;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;

public class IntervalUtil {
    private IntervalUtil() {
    }

    static ResourceBundle resourceBundle() {
        return LazyResourceBundleHolder.instance;
    }

    public static long distanceBetween(Interval firstIval, Interval secondIval) {
        return IntervalUtil.distanceBetween(firstIval, secondIval, null);
    }

    public static long distanceBetween(Interval firstIval, Interval secondIval, Unit units) {
        if (firstIval == null) {
            throw new IllegalArgumentException("firstIval cannot be null");
        }
        if (secondIval == null) {
            throw new IllegalArgumentException("secondIval cannot be null");
        }
        Granularity gran = firstIval.getFinishGranularity();
        if (units == null) {
            units = gran.getCorrespondingUnit();
        }
        return gran.distance(firstIval.getMinFinish(), secondIval.getMinStart(), gran, units);
    }

    public static String distanceBetweenFormattedShort(Interval firstIval, Interval secondIval) {
        return IntervalUtil.distanceBetweenFormattedShort(firstIval, secondIval, null);
    }

    public static String distanceBetweenFormattedShort(Interval firstIval, Interval secondIval, Unit units) {
        if (firstIval == null) {
            throw new IllegalArgumentException("firstIval cannot be null");
        }
        if (secondIval == null) {
            throw new IllegalArgumentException("secondIval cannot be null");
        }
        Granularity gran = firstIval.getFinishGranularity();
        if (units == null) {
            units = gran.getCorrespondingUnit();
        }
        long distance = gran.distance(firstIval.getMinFinish(), secondIval.getMinStart(), gran, units);
        return units.getShortFormat().format(distance);
    }

    public static String distanceBetweenFormattedMedium(Interval firstIval, Interval secondIval) {
        return IntervalUtil.distanceBetweenFormattedMedium(firstIval, secondIval, null);
    }

    public static String distanceBetweenFormattedMedium(Interval firstIval, Interval secondIval, Unit units) {
        if (firstIval == null) {
            throw new IllegalArgumentException("firstIval cannot be null");
        }
        if (secondIval == null) {
            throw new IllegalArgumentException("secondIval cannot be null");
        }
        Granularity gran = firstIval.getFinishGranularity();
        if (units == null) {
            units = gran.getCorrespondingUnit();
        }
        long distance = gran.distance(firstIval.getMinFinish(), secondIval.getMinStart(), gran, units);
        return units.getMediumFormat().format(distance);
    }

    public static String distanceBetweenFormattedLong(Interval firstIval, Interval secondIval) {
        return IntervalUtil.distanceBetweenFormattedLong(firstIval, secondIval, null);
    }

    public static String distanceBetweenFormattedLong(Interval firstIval, Interval secondIval, Unit units) {
        if (firstIval == null) {
            throw new IllegalArgumentException("firstIval cannot be null");
        }
        if (secondIval == null) {
            throw new IllegalArgumentException("secondIval cannot be null");
        }
        Granularity gran = firstIval.getFinishGranularity();
        if (units == null) {
            units = gran.getCorrespondingUnit();
        }
        long distance = gran.distance(firstIval.getMinFinish(), secondIval.getMinStart(), gran, units);
        return units.getLongFormat().format(distance);
    }

    private static class LazyResourceBundleHolder {
        private static ResourceBundle instance = ResourceBundle.getBundle("org.protempa.proposition.interval.Messages");

        private LazyResourceBundleHolder() {
        }
    }
}

