/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Granularity;

public final class SimpleInterval
extends Interval {
    SimpleInterval(Long minStart, Long maxStart, Granularity startGranularity, Long minFinish, Long maxFinish, Granularity finishGranularity) {
        super(minStart, maxStart, startGranularity, minFinish, maxFinish, finishGranularity, null, null, null);
        if (minStart == null) {
            throw new IllegalArgumentException("minStart cannot be null");
        }
        if (maxStart == null) {
            throw new IllegalArgumentException("maxStart cannot be null");
        }
        if (minFinish == null) {
            throw new IllegalArgumentException("minFinish cannot be null");
        }
        if (maxFinish == null) {
            throw new IllegalArgumentException("maxFinish cannot be null");
        }
    }

    SimpleInterval(Long start, Granularity startGranularity, Long finish, Granularity finishGranularity) {
        super(start, startGranularity, finish, finishGranularity, null, null);
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        if (finish == null) {
            throw new IllegalArgumentException("finish cannot be null");
        }
    }

    SimpleInterval(Long timestamp, Granularity granularity) {
        super(timestamp, granularity, timestamp, granularity, null, null);
        if (timestamp == null) {
            throw new IllegalArgumentException("timestamp cannot be null");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long start = this.getMinStart();
        long finish = this.getMinFinish();
        Granularity startGran = this.getStartGranularity();
        Granularity finishGran = this.getFinishGranularity();
        if (start == finish && startGran == finishGran) {
            s.writeChar(0);
            s.writeLong(start);
            s.writeObject(startGran);
        } else {
            s.writeChar(1);
            s.writeLong(start);
            s.writeLong(finish);
            s.writeObject(startGran);
            s.writeObject(finishGran);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        char mode = s.readChar();
        try {
            switch (mode) {
                case '\u0000': {
                    long tstamp = s.readLong();
                    Granularity gran = (Granularity)s.readObject();
                    try {
                        this.init(tstamp, gran, tstamp, gran, null, null);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new InvalidObjectException("Can't restore. Invalid interval arguments: " + iae.getMessage());
                    }
                }
                case '\u0001': {
                    long start = s.readLong();
                    long finish = s.readLong();
                    Granularity startGran = (Granularity)s.readObject();
                    Granularity finishGran = (Granularity)s.readObject();
                    try {
                        this.init(start, startGran, finish, finishGran, null, null);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new InvalidObjectException("Can't restore. Invalid interval arguments: " + iae.getMessage());
                    }
                }
                default: {
                    throw new InvalidObjectException("Can't restore. Invalid mode: " + mode);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidObjectException("Can't restore: " + iae.getMessage());
        }
    }
}

