/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.TemporalParameter;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;

public abstract class AbstractKaplanMeyer
extends AbstractPropositionVisitor {
    private final Map<SurvivalKey, Map<Long, Integer>> survival = new HashMap<SurvivalKey, Map<Long, Integer>>();
    private final Unit targetLengthUnit;

    AbstractKaplanMeyer() {
        this(null);
    }

    AbstractKaplanMeyer(Unit targetLengthUnit) {
        this.targetLengthUnit = targetLengthUnit;
    }

    public final LengthProportionPair[] getSurvivalCurveData() {
        Collection<Map<Long, Integer>> vals = this.survival.values();
        ArrayList<LengthCountPair> valsSorted = new ArrayList<LengthCountPair>();
        for (Map<Long, Integer> val : vals) {
            for (Map.Entry<Long, Integer> e : val.entrySet()) {
                valsSorted.add(new LengthCountPair(e.getKey(), e.getValue()));
            }
        }
        Collections.sort(valsSorted);
        int totalCount = valsSorted.size();
        LengthProportionPair[] result = new LengthProportionPair[totalCount + 1];
        result[0] = new LengthProportionPair(0L, 1.0f);
        long oldLength = 0L;
        boolean first = true;
        int count = totalCount;
        float totalCountf = totalCount;
        int n = valsSorted.size();
        for (int i = 0; i < n; ++i) {
            LengthCountPair lcp = (LengthCountPair)valsSorted.get(i);
            long lcpLength = lcp.length;
            if (!first) {
                if (lcpLength > oldLength) {
                    --count;
                }
            } else {
                first = false;
            }
            result[i + 1] = new LengthProportionPair(lcpLength, (float)count / totalCountf);
            oldLength = lcpLength;
        }
        return result;
    }

    public final Map<SurvivalKey, Map<Long, Integer>> getData() {
        return Collections.unmodifiableMap(this.survival);
    }

    public final Map<Long, Integer> get(String id) {
        return this.survival.get(AbstractKaplanMeyer.makeKey(id, null));
    }

    public final Map<Long, Integer> get(String id, Value val) {
        return this.survival.get(AbstractKaplanMeyer.makeKey(id, val));
    }

    @Override
    public final void visit(AbstractParameter abstractParameter) {
        this.increment(abstractParameter);
    }

    @Override
    public final void visit(Event event) {
        this.processTemporalProposition(AbstractKaplanMeyer.makeKey(event.getId(), null), this.length(event, this.targetLengthUnit));
    }

    @Override
    public final void visit(PrimitiveParameter primitiveParameter) {
        this.increment(primitiveParameter);
    }

    private void increment(TemporalParameter temporalParameter) {
        SurvivalKey key = AbstractKaplanMeyer.makeKey(temporalParameter.getId(), temporalParameter.getValue());
        this.processTemporalProposition(key, this.length(temporalParameter, this.targetLengthUnit));
    }

    protected abstract Long length(TemporalProposition var1, Unit var2);

    private void processTemporalProposition(SurvivalKey key, Long length) {
        Map<Long, Integer> val = this.survival.get(key);
        if (val == null) {
            val = new HashMap<Long, Integer>();
            val.put(length, 1);
            this.survival.put(key, val);
        } else {
            Integer count = val.get(length);
            if (count == null) {
                val.put(length, 1);
            } else {
                val.put(length, count + 1);
            }
        }
    }

    private static SurvivalKey makeKey(String id, Value val) {
        return new SurvivalKey(id, val);
    }

    private static class LengthCountPair
    implements Comparable<LengthCountPair> {
        long length;
        Integer count;

        LengthCountPair(long length, Integer count) {
            this.length = length;
            this.count = count;
        }

        @Override
        public int compareTo(LengthCountPair o) {
            if (this.length > o.length) {
                return 1;
            }
            if (this.length < o.length) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "LengthCountPair: length=" + this.length + "; count=" + this.count;
        }
    }

    static class LengthProportionPair {
        private long length;
        private float proportion;

        LengthProportionPair(long length, float proportion) {
            this.length = length;
            this.proportion = proportion;
        }

        public long getLength() {
            return this.length;
        }

        public float getProportion() {
            return this.proportion;
        }

        public String toString() {
            return "Bin: length=" + this.length + "; proportion=" + this.proportion;
        }
    }

    static class SurvivalKey {
        private String id;
        private Value value;
        private volatile int hashCode = 0;

        SurvivalKey(String id, Value value) {
            this.id = id;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public Value getValue() {
            return this.value;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
                this.hashCode = result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SurvivalKey)) {
                return false;
            }
            SurvivalKey other = (SurvivalKey)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "SurvivalKey: id=" + this.id + "; value=" + this.value;
        }
    }
}

