/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.AbstractThread;
import org.protempa.DataSource;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventIterator;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.QueryException;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;

class RetrieveDataThread
extends AbstractThread {
    private static final Logger LOGGER = Logger.getLogger(RetrieveDataThread.class.getName());
    private final BlockingQueue<DataStreamingEvent<Proposition>> queue;
    private final DataStreamingEvent<Proposition> poisonPill;
    private final List<QueryException> exceptions;
    private final PropositionDefinitionCache propositionDefinitionCache;
    private final DataSource dataSource;
    private final QueryResultsHandler queryResultsHandler;
    private final Filter filters;

    RetrieveDataThread(BlockingQueue<DataStreamingEvent<Proposition>> queue, DataStreamingEvent<Proposition> poisonPill, Query query, DataSource dataSource, PropositionDefinitionCache propositionDefinitionCache, Filter filters, QueryResultsHandler queryResultsHandler) throws QueryException {
        super(query, LOGGER, "protempa.executor.RetrieveDataThread");
        this.queue = queue;
        this.poisonPill = poisonPill;
        this.exceptions = new ArrayList<QueryException>();
        this.dataSource = dataSource;
        this.propositionDefinitionCache = propositionDefinitionCache;
        this.filters = filters;
        this.queryResultsHandler = queryResultsHandler;
    }

    public List<QueryException> getExceptions() {
        return this.exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log(Level.FINER, "Start retrieve data thread");
        Query query = this.getQuery();
        boolean itrClosed = false;
        DataStreamingEventIterator<Proposition> itr = null;
        try {
            itr = this.newDataIterator();
            while (!this.isInterrupted() && itr.hasNext()) {
                this.queue.put(itr.next());
            }
            itr.close();
            this.queue.put(this.poisonPill);
            itrClosed = true;
        }
        catch (Error | RuntimeException | DataSourceReadException ex) {
            this.exceptions.add(new QueryException(query.getName(), ex));
            try {
                this.queue.put(this.poisonPill);
            }
            catch (InterruptedException ignore) {
                this.log(Level.SEVERE, "Failed to send stop message to the do process thread; the query may be hung", ignore);
            }
        }
        catch (InterruptedException ex) {
            this.log(Level.FINER, "Retrieve data thread interrupted", ex);
        }
        finally {
            if (!itrClosed) {
                try {
                    itr.close();
                }
                catch (DataSourceReadException ex) {}
            }
        }
        this.log(Level.FINER, "End retrieve data thread");
    }

    private DataStreamingEventIterator<Proposition> newDataIterator() throws DataSourceReadException {
        this.log(Level.INFO, "Retrieving data");
        Query query = this.getQuery();
        HashSet<String> inDataSourcePropIds = new HashSet<String>();
        for (PropositionDefinition pd : this.propositionDefinitionCache.getAll()) {
            if (!pd.getInDataSource()) continue;
            inDataSourcePropIds.add(pd.getId());
        }
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "Asking data source for {0}", StringUtils.join(inDataSourcePropIds, (String)", "));
        }
        return this.dataSource.readPropositions(Arrays.asSet((Object[])query.getKeyIds()), inDataSourcePropIds, this.filters, this.queryResultsHandler);
    }
}

