/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.AbstractSource;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.KnowledgeSourceUpdatedEvent;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.SourceCloseException;
import org.protempa.SubtreePropositionDefinitionGetterRegular;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendNewInstanceException;
import org.protempa.backend.KnowledgeSourceBackendUpdatedEvent;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.valueset.ValueSet;

public final class KnowledgeSourceImpl
extends AbstractSource<KnowledgeSourceUpdatedEvent, KnowledgeSourceBackend, KnowledgeSourceUpdatedEvent, KnowledgeSourceBackendUpdatedEvent>
implements KnowledgeSource {
    private static final Logger LOGGER = Logger.getLogger(KnowledgeSourceImpl.class.getName());
    private final PropositionDefinitionReader propDefReader = new PropositionDefinitionReader();
    private final AbstractionDefinitionReader abstractionDefReader = new AbstractionDefinitionReader();
    private final ContextDefinitionReader contextDefReader = new ContextDefinitionReader();
    private final TemporalPropositionDefinitionReader tempPropDefReader = new TemporalPropositionDefinitionReader();
    private SubtreePropositionDefinitionGetterRegular inDataSourceGetter;
    private SubtreePropositionDefinitionGetterRegular collectSubtreeGetter;

    public KnowledgeSourceImpl(KnowledgeSourceBackend ... backends) {
        super((Backend[])backends);
    }

    private void initializeIfNeeded() throws BackendInitializationException, BackendNewInstanceException {
        if (this.isClosed()) {
            throw new IllegalStateException("Knowledge source already closed!");
        }
        if (this.inDataSourceGetter == null) {
            this.inDataSourceGetter = new SubtreePropositionDefinitionGetterRegular(this, true);
        }
        if (this.collectSubtreeGetter == null) {
            this.collectSubtreeGetter = new SubtreePropositionDefinitionGetterRegular(this, false);
        }
    }

    private void initializeIfNeeded(String template, String ... propIds) throws KnowledgeSourceReadException {
        try {
            this.initializeIfNeeded();
        }
        catch (BackendInitializationException | BackendNewInstanceException ex) {
            String action = MessageFormat.format(template, StringUtils.join((Object[])propIds, (String)", "));
            throw new KnowledgeSourceReadException("An error occurred " + action, ex);
        }
    }

    private void initializeIfNeeded(String action) throws KnowledgeSourceReadException {
        this.initializeIfNeeded(action, null);
    }

    @Override
    public List<PropositionDefinition> readInverseIsA(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        this.initializeIfNeeded("reading inverseIsA of {0}", propDef.getId());
        String[] propIds = propDef.getInverseIsA();
        result.addAll(this.readPropositionDefinitions(propIds));
        return result;
    }

    @Override
    public List<PropositionDefinition> readIsA(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readIsA(propDef.getId());
    }

    @Override
    public List<String> readIsAPropIds(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readIsAPropIds(propDef.getId());
    }

    @Override
    public List<PropositionDefinition> readInverseIsA(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        PropositionDefinition propDef = this.readPropositionDefinition(id);
        if (propDef == null) {
            return Collections.emptyList();
        }
        return this.readInverseIsA(propDef);
    }

    @Override
    public List<PropositionDefinition> readIsA(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet isAs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(isAs, (Object[][])new String[][]{backend.readIsA(id)});
        }
        return this.readPropositionDefinitions(isAs.toArray(new String[isAs.size()]));
    }

    @Override
    public List<String> readIsAPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet isAs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(isAs, (Object[][])new String[][]{backend.readIsA(id)});
        }
        return new ArrayList<String>(isAs);
    }

    @Override
    public List<PropositionDefinition> readAbstractedFrom(AbstractionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded("reading abstractedFrom of {0}", propDef.getId());
        Set<String> propIds = propDef.getAbstractedFrom();
        return this.readPropositionDefinitions(propIds.toArray(new String[propIds.size()]));
    }

    @Override
    public List<AbstractionDefinition> readAbstractedInto(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readAbstractedInto(propDef.getId());
    }

    @Override
    public List<String> readAbstractedIntoPropIds(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readAbstractedIntoPropIds(propDef.getId());
    }

    @Override
    public List<PropositionDefinition> readAbstractedFrom(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        AbstractionDefinition propDef = this.readAbstractionDefinition(id);
        if (propDef == null) {
            return Collections.emptyList();
        }
        return this.readAbstractedFrom(propDef);
    }

    @Override
    public List<AbstractionDefinition> readAbstractedInto(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet abstractedIntos = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(abstractedIntos, (Object[][])new String[][]{backend.readAbstractedInto(id)});
        }
        return this.readAbstractionDefinitions(abstractedIntos.toArray(new String[abstractedIntos.size()]));
    }

    @Override
    public List<String> readAbstractedIntoPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet abstractedIntos = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(abstractedIntos, (Object[][])new String[][]{backend.readAbstractedInto(id)});
        }
        return new ArrayList<String>(abstractedIntos);
    }

    @Override
    public List<ContextDefinition> readInduces(TemporalPropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readInduces(propDef.getId());
    }

    @Override
    public List<String> readInducesPropIds(TemporalPropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readInducesPropIds(propDef.getId());
    }

    @Override
    public List<ContextDefinition> readInduces(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet induces = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(induces, (Object[][])new String[][]{backend.readInduces(id)});
        }
        return this.readContextDefinitions(induces.toArray(new String[induces.size()]));
    }

    @Override
    public List<String> readInducesPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet induces = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(induces, (Object[][])new String[][]{backend.readInduces(id)});
        }
        return new ArrayList<String>(induces);
    }

    @Override
    public List<ContextDefinition> readSubContextOfs(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet subContextOfs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(subContextOfs, (Object[][])new String[][]{backend.readSubContextOfs(id)});
        }
        return this.readContextDefinitions(subContextOfs.toArray(new String[subContextOfs.size()]));
    }

    @Override
    public List<String> readSubContextOfPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet subContextOfs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(subContextOfs, (Object[][])new String[][]{backend.readSubContextOfs(id)});
        }
        return new ArrayList<String>(subContextOfs);
    }

    @Override
    public List<ContextDefinition> readSubContextOfs(ContextDefinition cd) throws KnowledgeSourceReadException {
        if (cd == null) {
            throw new IllegalArgumentException("cd cannot be null");
        }
        return this.readSubContextOfs(cd.getId());
    }

    @Override
    public List<String> readSubContextOfPropIds(ContextDefinition cd) throws KnowledgeSourceReadException {
        if (cd == null) {
            throw new IllegalArgumentException("cd cannot be null");
        }
        return this.readSubContextOfPropIds(cd.getId());
    }

    @Override
    public List<ContextDefinition> readSubContexts(String contextId) throws KnowledgeSourceReadException {
        if (contextId == null) {
            throw new IllegalArgumentException("contextId cannot be null");
        }
        ContextDefinition pd = this.readContextDefinition(contextId);
        if (pd != null) {
            return this.readSubContexts(pd);
        }
        return new ArrayList<ContextDefinition>(0);
    }

    @Override
    public List<ContextDefinition> readSubContexts(ContextDefinition contextDef) throws KnowledgeSourceReadException {
        if (contextDef == null) {
            throw new IllegalArgumentException("contextDef cannot be null");
        }
        this.initializeIfNeeded("reading subContexts of {0}", contextDef.getId());
        String[] propIds = contextDef.getSubContexts();
        return this.readContextDefinitions(propIds);
    }

    @Override
    public List<PropositionDefinition> readParents(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        List<String> result = this.readParentPropIds(propDef);
        return this.readPropositionDefinitions(result.toArray(new String[result.size()]));
    }

    @Override
    public List<String> readParentPropIds(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        List<Object> induces;
        List<Object> subContextOfs;
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        if (propDef instanceof ContextDefinition) {
            subContextOfs = this.readSubContextOfPropIds((ContextDefinition)propDef);
            induces = this.readInducesPropIds((ContextDefinition)propDef);
        } else {
            subContextOfs = Collections.emptyList();
            induces = Collections.emptyList();
        }
        List<String> ad = this.readAbstractedIntoPropIds(propDef);
        List<String> pd = this.readIsAPropIds(propDef);
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(subContextOfs);
        result.addAll(induces);
        result.addAll(ad);
        result.addAll(pd);
        return new ArrayList<String>(result);
    }

    @Override
    public List<PropositionDefinition> readParents(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        PropositionDefinition pd = this.readPropositionDefinition(propId);
        if (pd != null) {
            return this.readParents(pd);
        }
        return new ArrayList<PropositionDefinition>(0);
    }

    @Override
    public List<String> readParentPropIds(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        PropositionDefinition pd = this.readPropositionDefinition(propId);
        if (pd != null) {
            return this.readParentPropIds(pd);
        }
        return new ArrayList<String>(0);
    }

    @Override
    public List<TemporalPropositionDefinition> readInducedBy(String contextId) throws KnowledgeSourceReadException {
        if (contextId == null) {
            throw new IllegalArgumentException("contextId cannot be null");
        }
        ContextDefinition pd = this.readContextDefinition(contextId);
        if (pd != null) {
            return this.readInducedBy(pd);
        }
        return new ArrayList<TemporalPropositionDefinition>(0);
    }

    @Override
    public List<TemporalPropositionDefinition> readInducedBy(ContextDefinition contextDef) throws KnowledgeSourceReadException {
        if (contextDef == null) {
            throw new IllegalArgumentException("contextDef cannot be null");
        }
        ArrayList result = new ArrayList();
        this.initializeIfNeeded("reading inducedBy of {0}", contextDef.getId());
        TemporalExtendedPropositionDefinition[] tepds = contextDef.getInducedBy();
        HashSet<String> propIds = new HashSet<String>();
        for (TemporalExtendedPropositionDefinition tepd : tepds) {
            propIds.add(tepd.getPropositionId());
        }
        return this.readTemporalPropositionDefinitions(propIds.toArray(new String[propIds.size()]));
    }

    @Override
    public boolean hasTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.tempPropDefReader.has(id);
    }

    @Override
    public TemporalPropositionDefinition readTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return (TemporalPropositionDefinition)this.tempPropDefReader.read(id);
    }

    @Override
    public List<TemporalPropositionDefinition> readTemporalPropositionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.tempPropDefReader.read(propIds);
    }

    @Override
    public PropositionDefinition readPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.propDefReader.read(id);
    }

    @Override
    public List<PropositionDefinition> readPropositionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.propDefReader.read(propIds);
    }

    @Override
    public boolean hasPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.propDefReader.has(id);
    }

    @Override
    public AbstractionDefinition readAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        return (AbstractionDefinition)this.abstractionDefReader.read(id);
    }

    @Override
    public List<AbstractionDefinition> readAbstractionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.abstractionDefReader.read(propIds);
    }

    @Override
    public ContextDefinition readContextDefinition(String id) throws KnowledgeSourceReadException {
        return (ContextDefinition)this.contextDefReader.read(id);
    }

    @Override
    public List<ContextDefinition> readContextDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.contextDefReader.read(propIds);
    }

    @Override
    public boolean hasAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        return this.abstractionDefReader.has(id);
    }

    @Override
    public boolean hasContextDefinition(String id) throws KnowledgeSourceReadException {
        return this.contextDefReader.has(id);
    }

    @Override
    public ValueSet readValueSet(String id) throws KnowledgeSourceReadException {
        ValueSet result = null;
        this.initializeIfNeeded("reading the value set {0}", id);
        if (this.getBackends() != null) {
            for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
                result = backend.readValueSet(id);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public boolean hasValueSet(String id) throws KnowledgeSourceReadException {
        boolean result = false;
        if (!result) {
            this.initializeIfNeeded("reading the value set {0}", id);
            for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
                boolean bl = result = backend.readValueSet(id) != null;
                if (!result) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public void close() throws SourceCloseException {
        this.clear();
        super.close();
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> collectPropIdDescendantsUsingAllNarrower(boolean inDataSourceOnly, String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition ids for {0} with inDataSource set to true", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.inDataSourceGetter.subtreePropIds(inDataSourceOnly, propIds);
    }

    @Override
    public Set<PropositionDefinition> collectPropDefDescendantsUsingAllNarrower(boolean inDataSourceOnly, String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition definitions for {0} with inDataSource set to true", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.inDataSourceGetter.subtreePropDefs(inDataSourceOnly, propIds);
    }

    @Override
    public Set<String> collectPropIdDescendantsUsingInverseIsA(String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition ids for {0}", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.collectSubtreeGetter.subtreePropIds(false, propIds);
    }

    @Override
    public Set<PropositionDefinition> collectPropDefDescendantsUsingInverseIsA(String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition definitions for {0}", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.collectSubtreeGetter.subtreePropDefs(false, propIds);
    }

    @Override
    public void backendUpdated(KnowledgeSourceBackendUpdatedEvent event) {
        this.clear();
        this.fireKnowledgeSourceUpdated();
    }

    private void fireKnowledgeSourceUpdated() {
        this.fireSourceUpdated(new KnowledgeSourceUpdatedEvent(this));
    }

    @Override
    public List<String> getMatchingPropIds(String searchKey) throws KnowledgeSourceReadException {
        LOGGER.log(Level.INFO, "Searching knowledge source For search string {0}", searchKey);
        Set<String> searchResults = this.getSearchResultsFromBackend(searchKey);
        return new ArrayList<String>(searchResults);
    }

    private Set<String> getSearchResultsFromBackend(String searchKey) throws KnowledgeSourceReadException {
        HashSet<String> results = new HashSet<String>();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            results.addAll(backend.getKnowledgeSourceSearchResults(searchKey));
        }
        return results;
    }

    private final class TemporalPropositionDefinitionReader
    extends AbstractDefinitionReader<TemporalPropositionDefinition> {
        private TemporalPropositionDefinitionReader() {
        }

        @Override
        protected TemporalPropositionDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readTemporalPropositionDefinition(id);
        }

        @Override
        protected List<TemporalPropositionDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readTemporalPropositionDefinitions(ids.toArray(new String[ids.size()]));
        }
    }

    private final class ContextDefinitionReader
    extends AbstractDefinitionReader<ContextDefinition> {
        private ContextDefinitionReader() {
        }

        @Override
        protected ContextDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readContextDefinition(id);
        }

        @Override
        protected List<ContextDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readContextDefinitions(ids.toArray(new String[ids.size()]));
        }
    }

    private final class AbstractionDefinitionReader
    extends AbstractDefinitionReader<AbstractionDefinition> {
        private AbstractionDefinitionReader() {
        }

        @Override
        protected AbstractionDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readAbstractionDefinition(id);
        }

        @Override
        protected List<AbstractionDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readAbstractionDefinitions(ids.toArray(new String[ids.size()]));
        }
    }

    private final class PropositionDefinitionReader
    extends AbstractDefinitionReader<PropositionDefinition> {
        private PropositionDefinitionReader() {
        }

        @Override
        protected PropositionDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readPropositionDefinition(id);
        }

        @Override
        protected List<PropositionDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readPropositionDefinitions(ids.toArray(new String[ids.size()]));
        }
    }

    private abstract class AbstractDefinitionReader<E extends PropositionDefinition> {
        private AbstractDefinitionReader() {
        }

        final E read(String id) throws KnowledgeSourceReadException {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            KnowledgeSourceImpl.this.initializeIfNeeded("reading the proposition definition {0}", new String[]{id});
            E result = null;
            if (result == null) {
                for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])KnowledgeSourceImpl.this.getBackends()) {
                    result = this.readFromBackend(id, backend);
                    if (result == null) continue;
                    return result;
                }
            }
            return result;
        }

        final List<E> read(String[] ids) throws KnowledgeSourceReadException {
            assert (ids != null) : "ids cannot be null";
            KnowledgeSourceImpl.this.initializeIfNeeded("reading the proposition definitions {0}", ids);
            ArrayList<E> result = new ArrayList<E>();
            for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])KnowledgeSourceImpl.this.getBackends()) {
                result.addAll(this.readFromBackend(Arrays.asList((Object[][])new String[][]{ids}), backend));
            }
            return result;
        }

        final boolean has(String id) throws KnowledgeSourceReadException {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            return this.read(id) != null;
        }

        protected abstract E readFromBackend(String var1, KnowledgeSourceBackend var2) throws KnowledgeSourceReadException;

        protected abstract List<E> readFromBackend(List<String> var1, KnowledgeSourceBackend var2) throws KnowledgeSourceReadException;
    }
}

