/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.backend.AlgorithmSourceBackendUpdatedEvent;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.BackendProvider;
import org.protempa.backend.BackendProviderManager;
import org.protempa.backend.BackendProviderSpecLoaderException;
import org.protempa.backend.BackendSpec;
import org.protempa.backend.BackendSpecLoader;
import org.protempa.backend.BackendSpecNotFoundException;
import org.protempa.backend.BackendUtil;
import org.protempa.backend.Configuration;
import org.protempa.backend.ConfigurationsLoadException;
import org.protempa.backend.InvalidConfigurationException;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;

public class ConfigurationsSupport {
    private final BackendProvider backendProvider;
    private final List<BackendInstanceSpec<AlgorithmSourceBackend>> asbInstanceSpecs;
    private final List<BackendInstanceSpec<DataSourceBackend>> dsbInstanceSpecs;
    private final List<BackendInstanceSpec<KnowledgeSourceBackend>> ksbInstanceSpecs;
    private BackendSpecLoader<AlgorithmSourceBackend> asl;
    private BackendSpecLoader<DataSourceBackend> dsl;
    private BackendSpecLoader<KnowledgeSourceBackend> ksl;
    private String configurationId;

    public ConfigurationsSupport(BackendProvider backendProvider) {
        Logger logger = BackendUtil.logger();
        this.backendProvider = backendProvider != null ? backendProvider : BackendProviderManager.getBackendProvider();
        logger.log(Level.FINE, "Got backend provider {0}", this.backendProvider.getClass().getName());
        this.asbInstanceSpecs = new ArrayList<BackendInstanceSpec<AlgorithmSourceBackend>>();
        this.dsbInstanceSpecs = new ArrayList<BackendInstanceSpec<DataSourceBackend>>();
        this.ksbInstanceSpecs = new ArrayList<BackendInstanceSpec<KnowledgeSourceBackend>>();
    }

    public void init(String configurationId) throws ConfigurationsLoadException {
        this.configurationId = configurationId;
        try {
            this.asl = this.backendProvider.getAlgorithmSourceBackendSpecLoader();
            this.dsl = this.backendProvider.getDataSourceBackendSpecLoader();
            this.ksl = this.backendProvider.getKnowledgeSourceBackendSpecLoader();
        }
        catch (BackendProviderSpecLoaderException ex) {
            throw new ConfigurationsLoadException(ex);
        }
    }

    public BackendInstanceSpec<? extends Backend> load(String sectionId) throws ConfigurationsLoadException, InvalidConfigurationException {
        BackendInstanceSpec<Backend<AlgorithmSourceBackendUpdatedEvent>> result;
        block5: {
            try {
                if (this.asl.hasSpec(sectionId)) {
                    BackendInstanceSpec<AlgorithmSourceBackend> newBackendInstanceSpec;
                    BackendSpec<AlgorithmSourceBackend> loadSpec = this.asl.loadSpec(sectionId);
                    result = newBackendInstanceSpec = loadSpec.newBackendInstanceSpec();
                    this.asbInstanceSpecs.add(newBackendInstanceSpec);
                    break block5;
                }
                if (this.dsl.hasSpec(sectionId)) {
                    BackendSpec<DataSourceBackend> loadSpec = this.dsl.loadSpec(sectionId);
                    BackendInstanceSpec<DataSourceBackend> newBackendInstanceSpec = loadSpec.newBackendInstanceSpec();
                    result = newBackendInstanceSpec;
                    this.dsbInstanceSpecs.add(newBackendInstanceSpec);
                    break block5;
                }
                if (this.ksl.hasSpec(sectionId)) {
                    BackendSpec<KnowledgeSourceBackend> loadSpec = this.ksl.loadSpec(sectionId);
                    BackendInstanceSpec<KnowledgeSourceBackend> newBackendInstanceSpec = loadSpec.newBackendInstanceSpec();
                    result = newBackendInstanceSpec;
                    this.ksbInstanceSpecs.add(newBackendInstanceSpec);
                    break block5;
                }
                throw new InvalidConfigurationException("The backend " + sectionId + " was not found");
            }
            catch (BackendSpecNotFoundException e) {
                throw new InvalidConfigurationException("The backend " + sectionId + " was not found");
            }
        }
        return result;
    }

    public List<BackendInstanceSpec<AlgorithmSourceBackend>> getAlgorithmSourceBackendInstanceSpecs() {
        return this.asbInstanceSpecs;
    }

    public List<BackendInstanceSpec<DataSourceBackend>> getDataSourceBackendInstanceSpecs() {
        return this.dsbInstanceSpecs;
    }

    public List<BackendInstanceSpec<KnowledgeSourceBackend>> getKnowledgeSourceBackendInstanceSpecs() {
        return this.ksbInstanceSpecs;
    }

    public Configuration buildConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setConfigurationId(this.configurationId);
        configuration.setAlgorithmSourceBackendSections(this.asbInstanceSpecs);
        configuration.setDataSourceBackendSections(this.dsbInstanceSpecs);
        configuration.setKnowledgeSourceBackendSections(this.ksbInstanceSpecs);
        return configuration;
    }
}

