/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.SourceSystem;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;

public abstract class AbstractProposition
implements Proposition {
    private static final int DEFAULT_REFERENCE_LIST_SIZE = 100;
    private static final SourceSystem DEFAULT_SOURCE_SYSTEM = SourceSystem.UNKNOWN;
    private String id;
    private Map<String, Value> properties;
    private Map<String, List<UniqueId>> references;
    private UniqueId uniqueId;
    private SourceSystem sourceSystem = DEFAULT_SOURCE_SYSTEM;
    private Date downloadDate;
    private Date createDate;
    private Date updateDate;
    private Date deleteDate;

    AbstractProposition(String id, UniqueId uniqueId) {
        this();
        if (uniqueId == null) {
            throw new IllegalArgumentException("The unique ID cannot be null");
        }
        this.initializeAbstractProposition(id, uniqueId);
    }

    protected AbstractProposition() {
    }

    protected final void initializeAbstractProposition(String id, UniqueId uniqueId) {
        this.uniqueId = uniqueId;
        this.id = id == null ? "" : id.intern();
    }

    protected void initializeProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Value>();
        }
    }

    protected void initializeReferences() {
        if (this.references == null) {
            this.references = new LinkedHashMap<String, List<UniqueId>>();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public final void setProperty(String name, Value value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.initializeProperties();
        this.properties.put(name.intern(), value);
    }

    @Override
    public final Value getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public final String[] getPropertyNames() {
        if (this.properties == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Set<String> propNames = this.properties.keySet();
        return propNames.toArray(new String[propNames.size()]);
    }

    @Override
    public SourceSystem getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(SourceSystem sourceSystem) {
        this.sourceSystem = sourceSystem != null ? sourceSystem : DEFAULT_SOURCE_SYSTEM;
    }

    @Override
    public final UniqueId getUniqueId() {
        return this.uniqueId;
    }

    public final void setReferences(String name, List<UniqueId> refs) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.initializeReferences();
        this.references.put(name.intern(), new ArrayList<UniqueId>(refs));
    }

    public final void addReference(String name, UniqueId ref) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (ref == null) {
            throw new IllegalArgumentException("ref cannot be null");
        }
        this.initializeReferences();
        List<UniqueId> refs = this.references.get(name);
        if (refs == null) {
            refs = new ArrayList<UniqueId>(100);
            refs.add(ref);
            this.references.put(name.intern(), refs);
        } else {
            refs.add(ref);
        }
    }

    @Override
    public final List<UniqueId> getReferences(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.references == null) {
            return Collections.emptyList();
        }
        List<UniqueId> result = this.references.get(name);
        if (result != null) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    @Override
    public final String[] getReferenceNames() {
        if (this.references == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Set<String> refNames = this.references.keySet();
        return refNames.toArray(new String[refNames.size()]);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractProposition) {
            AbstractProposition other = (AbstractProposition)o;
            return this.uniqueId.equals(other.uniqueId);
        }
        return false;
    }

    @Override
    public boolean isEqual(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AbstractProposition)) {
            return false;
        }
        AbstractProposition p = (AbstractProposition)other;
        return (this.id == p.id || this.id.equals(p.id)) && this.properties == p.properties || this.properties != null && this.properties.equals(p.properties);
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }

    protected void writeAbstractProposition(ObjectOutputStream s) throws IOException {
        s.writeObject(this.id);
        s.writeObject(this.uniqueId);
        if (this.properties == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.properties.size());
            for (Map.Entry<String, Value> entry : this.properties.entrySet()) {
                String propertyName = entry.getKey();
                Value val = entry.getValue();
                s.writeObject(propertyName);
                s.writeObject(val);
            }
        }
        if (this.references == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.references.size());
            for (Map.Entry<String, Object> entry : this.references.entrySet()) {
                s.writeObject(entry.getKey());
                List val = (List)entry.getValue();
                if (val == null) {
                    s.writeInt(0);
                    continue;
                }
                s.writeInt(val.size());
                for (UniqueId uid : val) {
                    s.writeObject(uid);
                }
            }
        }
        s.writeObject(this.sourceSystem);
        s.writeObject(this.createDate);
        s.writeObject(this.updateDate);
        s.writeObject(this.deleteDate);
        s.writeObject(this.downloadDate);
    }

    protected void readAbstractProposition(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int numRefs;
        String tempId = (String)s.readObject();
        UniqueId tempUniqueId = (UniqueId)s.readObject();
        if (tempUniqueId == null) {
            throw new InvalidObjectException("Can't restore. All propositions must have an unique id");
        }
        this.initializeAbstractProposition(tempId, tempUniqueId);
        int numProperties = s.readInt();
        if (numProperties < 0) {
            throw new InvalidObjectException("Negative properties count. Can't restore");
        }
        if (numProperties > 0) {
            for (int i = 0; i < numProperties; ++i) {
                String propertyName = (String)s.readObject();
                Value val = (Value)s.readObject();
                if (val != null) {
                    val = val.replace();
                }
                this.setProperty(propertyName, val);
            }
        }
        if ((numRefs = s.readInt()) < 0) {
            throw new InvalidObjectException("Negative reference count. Can't restore");
        }
        if (numRefs > 0) {
            for (int i = 0; i < numRefs; ++i) {
                String refName = (String)s.readObject();
                int numUids = s.readInt();
                if (numUids < 0) {
                    throw new InvalidObjectException("Negative unique identifier count. Can't restore");
                }
                ArrayList<UniqueId> uids = new ArrayList<UniqueId>(numUids);
                for (int j = 0; j < numUids; ++j) {
                    uids.add((UniqueId)s.readObject());
                }
                this.setReferences(refName, uids);
            }
        }
        this.setSourceSystem((SourceSystem)s.readObject());
        this.setCreateDate((Date)s.readObject());
        this.setUpdateDate((Date)s.readObject());
        this.setDeleteDate((Date)s.readObject());
        this.setDownloadDate((Date)s.readObject());
    }

    @Override
    public final Date getCreateDate() {
        return this.createDate;
    }

    public final void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public final Date getUpdateDate() {
        return this.updateDate;
    }

    public final void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public final Date getDownloadDate() {
        return this.downloadDate;
    }

    public final void setDownloadDate(Date downloadDate) {
        this.downloadDate = downloadDate;
    }

    @Override
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }
}

