/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.AbstractAbstractionDefinition;
import org.protempa.ClassificationMatrixValue;
import org.protempa.ContextDefinition;
import org.protempa.GapFunction;
import org.protempa.ParameterDefinition;
import org.protempa.PropositionDefinitionCheckedVisitor;
import org.protempa.PropositionDefinitionVisitor;
import org.protempa.ProtempaException;
import org.protempa.ValueClassification;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.ValueType;

public final class CompoundLowLevelAbstractionDefinition
extends AbstractAbstractionDefinition
implements ParameterDefinition {
    private static final long serialVersionUID = -1285908778762502403L;
    private final Set<String> lowLevelIds = new HashSet<String>();
    private GapFunction gapBtwValues;
    private ContextDefinition interpretationContext;
    private String contextId;
    private int skip = -1;
    private transient LinkedHashMap<String, List<ClassificationMatrixValue>> classificationMatrix;
    private transient List<ValueClassification> valueClassifications;
    private int minimumNumberOfValues = 1;
    private ValueDefinitionMatchOperator valueDefinitionMatchOperator = ValueDefinitionMatchOperator.ANY;
    private boolean concatenable = true;

    public CompoundLowLevelAbstractionDefinition(String id) {
        super(id);
        this.gapBtwValues = GapFunction.DEFAULT;
        this.initInstance();
    }

    private void initInstance() {
        this.classificationMatrix = new LinkedHashMap();
        this.valueClassifications = new ArrayList<ValueClassification>();
    }

    public Set<String> getLowLevelAbstractionIds() {
        return Collections.unmodifiableSet(this.lowLevelIds);
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public void setGapFunctionBetweenValues(GapFunction gf) {
        this.gapBtwValues = gf == null ? GapFunction.DEFAULT : gf;
    }

    public GapFunction getGapFunctionBetweenValues() {
        return this.gapBtwValues;
    }

    public int getMinimumNumberOfValues() {
        return this.minimumNumberOfValues;
    }

    public void setMinimumNumberOfValues(int minimumNumberOfValues) {
        if (minimumNumberOfValues < 1) {
            throw new IllegalArgumentException("minimumNumberOfValues must be > 0");
        }
        this.minimumNumberOfValues = minimumNumberOfValues;
    }

    public ValueDefinitionMatchOperator getValueDefinitionMatchOperator() {
        return this.valueDefinitionMatchOperator;
    }

    public void setValueDefinitionMatchOperator(ValueDefinitionMatchOperator valueDefinitionMatchOperator) {
        this.valueDefinitionMatchOperator = valueDefinitionMatchOperator == null ? ValueDefinitionMatchOperator.ANY : valueDefinitionMatchOperator;
    }

    public void addValueClassification(ValueClassification valueClassification) {
        if (valueClassification == null) {
            throw new IllegalArgumentException("valueClassification cannot be null");
        }
        if (!this.classificationMatrix.containsKey(valueClassification.value)) {
            this.classificationMatrix.put(valueClassification.value, new ArrayList());
        }
        this.lowLevelIds.add(valueClassification.lladId);
        this.classificationMatrix.get(valueClassification.value).add(new ClassificationMatrixValue(valueClassification.lladId, NominalValue.getInstance(valueClassification.lladValue)));
        this.valueClassifications.add(valueClassification);
        this.recalculateChildren();
    }

    LinkedHashMap<String, List<ClassificationMatrixValue>> getValueClassificationsInt() {
        return this.classificationMatrix;
    }

    public ValueClassification[] getValueClassifications() {
        return this.valueClassifications.toArray(new ValueClassification[this.valueClassifications.size()]);
    }

    @Override
    public Set<String> getAbstractedFrom() {
        return this.getLowLevelAbstractionIds();
    }

    public void setConcatenable(boolean concatenable) {
        this.concatenable = concatenable;
    }

    @Override
    public boolean isConcatenable() {
        return this.concatenable;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    public ContextDefinition getInterpretationContext() {
        return this.interpretationContext;
    }

    public void setInterpretationContext(ContextDefinition interpretationContext) {
        this.interpretationContext = interpretationContext;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.NOMINALVALUE;
    }

    @Override
    public void acceptChecked(PropositionDefinitionCheckedVisitor propositionVisitor) throws ProtempaException {
        if (propositionVisitor == null) {
            throw new IllegalArgumentException("propositionVisitor cannot be null");
        }
        propositionVisitor.visit(this);
    }

    @Override
    public void accept(PropositionDefinitionVisitor propositionVisitor) {
        if (propositionVisitor == null) {
            throw new IllegalArgumentException("propositionVisitor cannot be null");
        }
        propositionVisitor.visit(this);
    }

    @Override
    protected void recalculateChildren() {
        this.children = this.lowLevelIds.toArray(new String[this.lowLevelIds.size()]);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.valueClassifications.size());
        for (ValueClassification vc : this.valueClassifications) {
            s.writeObject(vc);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.minimumNumberOfValues < 1) {
            throw new InvalidObjectException("minimumNumberOfValues must be > 0");
        }
        this.initInstance();
        int numValueClassifications = s.readInt();
        for (int i = 0; i < numValueClassifications; ++i) {
            ValueClassification vc = (ValueClassification)s.readObject();
            if (vc == null) {
                throw new InvalidObjectException("null ValueClassification");
            }
            this.addValueClassification(vc);
        }
    }

    @Override
    public String toString() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this);
        builder.setAppendTransients(true);
        return builder.toString();
    }

    public static enum ValueDefinitionMatchOperator {
        ANY,
        ALL;

    }
}

