/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventIterator;
import org.protempa.proposition.Proposition;

final class DataStreamerIterator<E extends Proposition>
implements AutoCloseable {
    private final List<DataStreamingEventIterator<E>> itrs;
    private final List<DataStreamingEvent<E>> currentElt;
    private boolean hasNext;
    private DataStreamingEvent<E> result;
    private boolean hasNextComputed;
    private int i = 0;
    private DataStreamingEvent<E> currentMin;
    private String nextKeyId;

    DataStreamerIterator(List<DataStreamingEventIterator<E>> itrs) throws DataSourceReadException {
        int j;
        assert (itrs != null) : "itrs cannot be null";
        this.itrs = itrs;
        this.currentElt = new ArrayList<DataStreamingEvent<E>>(itrs.size());
        int itrsSize = itrs.size();
        for (j = 0; j < itrsSize; ++j) {
            this.currentElt.add(null);
        }
        for (j = 0; j < itrsSize; ++j) {
            this.advance(j);
        }
        for (DataStreamingEvent<E> event : this.currentElt) {
            if (event == null) continue;
            this.hasNext = true;
            break;
        }
    }

    String getNextKeyId() {
        return this.nextKeyId;
    }

    boolean hasNext() throws DataSourceReadException {
        if (!this.hasNextComputed) {
            boolean stayInLoop;
            do {
                stayInLoop = false;
                if (this.i == 0) {
                    this.currentMin = null;
                    for (DataStreamingEvent<E> elt : this.currentElt) {
                        this.currentMin = this.min(elt);
                    }
                }
                if (this.currentMin == null) {
                    this.hasNext = false;
                    continue;
                }
                int n = this.currentElt.size();
                while (this.i < n) {
                    DataStreamingEvent<E> elt;
                    elt = this.currentElt.get(this.i);
                    if (elt != null && elt.getKeyId().equals(this.currentMin != null ? this.currentMin.getKeyId() : null)) {
                        this.result = elt;
                        this.nextKeyId = elt.getKeyId();
                        this.advance(this.i);
                        ++this.i;
                        break;
                    }
                    ++this.i;
                }
                if (this.i != n || this.result != null) continue;
                this.i = 0;
                stayInLoop = true;
            } while (this.hasNext && stayInLoop);
            this.hasNextComputed = true;
        }
        return this.hasNext;
    }

    DataStreamingEvent<E> next() {
        assert (this.result != null) : "result cannot be null";
        this.hasNextComputed = false;
        DataStreamingEvent<E> r = this.result;
        this.result = null;
        this.nextKeyId = null;
        return r;
    }

    private void advance(int j) throws DataSourceReadException {
        DataStreamingEventIterator<E> itr = this.itrs.get(j);
        if (itr.hasNext()) {
            DataStreamingEvent<E> next = itr.next();
            this.currentElt.set(j, next);
        } else {
            this.currentElt.set(j, null);
        }
    }

    private DataStreamingEvent min(DataStreamingEvent elt2) {
        DataStreamingEvent elt1 = this.currentMin;
        if (elt1 == null) {
            return elt2;
        }
        if (elt2 == null) {
            return elt1;
        }
        return elt1.getKeyId().compareTo(elt2.getKeyId()) < 0 ? elt1 : elt2;
    }

    @Override
    public void close() {
    }
}

