/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashMap;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.valueset.ValueSet;

public final class KnowledgeSourceCacheFactory {
    public KnowledgeSourceCache getInstance(KnowledgeSource ks, PropositionDefinitionCache cache, boolean collectValueSets) throws KnowledgeSourceReadException {
        HashMap<String, ValueSet> vsCache;
        if (collectValueSets) {
            vsCache = new HashMap<String, ValueSet>();
            for (PropositionDefinition propDef : cache.getAll()) {
                for (PropertyDefinition pd : propDef.getPropertyDefinitions()) {
                    String valueSetId = pd.getValueSetId();
                    if (valueSetId == null || vsCache.containsKey(valueSetId)) continue;
                    vsCache.put(valueSetId, ks.readValueSet(valueSetId));
                }
            }
        } else {
            vsCache = null;
        }
        return new KnowledgeSourceCache(cache, vsCache);
    }
}

