/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.Algorithm;
import org.protempa.AlgorithmInitializationException;
import org.protempa.AlgorithmProcessingException;
import org.protempa.DerivationsBuilder;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.LowLevelAbstractionFinder;
import org.protempa.ObjectAsserter;
import org.protempa.proposition.Context;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.interval.Relation;

final class LowLevelAbstractionConsequence
implements Consequence {
    private static final long serialVersionUID = 2455607587534331595L;
    private static final Logger LOGGER = Logger.getLogger(LowLevelAbstractionConsequence.class.getName());
    private static final Relation REL = new Relation(null, null, 0, null, null, null, null, null, null, null, null, null, 0, null, null, null);
    private final LowLevelAbstractionDefinition def;
    private final Algorithm algorithm;
    private final DerivationsBuilder derivationsBuilder;
    private transient MyObjectAsserter objAsserter;

    private void doProcess(KnowledgeHelper knowledgeHelper, Sequence<PrimitiveParameter> subSeq) throws AlgorithmProcessingException, AlgorithmInitializationException {
        this.objAsserter.knowledgeHelper = knowledgeHelper;
        LowLevelAbstractionFinder.process(subSeq, this.def, this.algorithm, this.objAsserter, this.derivationsBuilder, knowledgeHelper.getWorkingMemory());
        this.objAsserter.knowledgeHelper = null;
    }

    LowLevelAbstractionConsequence(LowLevelAbstractionDefinition simpleAbstractionDef, Algorithm algorithm, DerivationsBuilder derivationsBuilder) {
        this.def = simpleAbstractionDef;
        this.algorithm = algorithm;
        this.derivationsBuilder = derivationsBuilder;
        this.objAsserter = new MyObjectAsserter();
    }

    public void evaluate(KnowledgeHelper kh, WorkingMemory wm) throws Exception {
        List pl = (List)kh.get(kh.getDeclaration("result"));
        Declaration declaration = kh.getDeclaration("result2");
        Sequence<PrimitiveParameter> seq = new Sequence<PrimitiveParameter>(this.def.getAbstractedFrom(), pl);
        if (declaration != null) {
            List contexts = (List)kh.get(kh.getDeclaration("result2"));
            Sequence contextSeq = new Sequence(this.def.getContextId(), contexts);
            LinkedList<PrimitiveParameter> ll = new LinkedList<PrimitiveParameter>(seq);
            for (Context context : contextSeq) {
                boolean in = false;
                Iterator itr = ll.iterator();
                PrimitiveParameter tp = (PrimitiveParameter)itr.next();
                Sequence<PrimitiveParameter> subSeq = new Sequence<PrimitiveParameter>(seq.getPropositionIds());
                while (true) {
                    if (REL.hasRelation(tp.getInterval(), context.getInterval())) {
                        subSeq.add(tp);
                        in = true;
                        itr.remove();
                    } else if (in) {
                        in = false;
                        break;
                    }
                    if (!itr.hasNext()) break;
                    tp = (PrimitiveParameter)itr.next();
                }
                if (subSeq.isEmpty()) continue;
                this.doProcess(kh, subSeq);
                subSeq.clear();
            }
        } else {
            this.doProcess(kh, seq);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.objAsserter = new MyObjectAsserter();
    }

    private static class MyObjectAsserter
    implements ObjectAsserter {
        private KnowledgeHelper knowledgeHelper;

        private MyObjectAsserter() {
        }

        @Override
        public void assertObject(Object obj) {
            this.knowledgeHelper.insertLogical(obj);
            LOGGER.log(Level.FINER, "Asserted derived proposition {0}", obj);
        }
    }
}

