/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.protempa.PropositionDefinition;
import org.protempa.QueryException;

public class PropositionDefinitionCache {
    private final Map<String, PropositionDefinition> cache = new HashMap<String, PropositionDefinition>();

    public PropositionDefinitionCache(Collection<? extends PropositionDefinition> propDefs) {
        for (PropositionDefinition propositionDefinition : propDefs) {
            this.cache.put(propositionDefinition.getId(), propositionDefinition);
        }
    }

    public Collection<PropositionDefinition> getAll() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    public PropositionDefinition get(String id) {
        return this.cache.get(id);
    }

    public Set<String> collectPropIdDescendantsUsingInverseIsA(String ... propIds) throws QueryException {
        String propId;
        HashSet<String> result = new HashSet<String>();
        LinkedList queue = new LinkedList();
        Arrays.addAll(queue, (Object[][])new String[][]{propIds});
        while ((propId = (String)queue.poll()) != null) {
            PropositionDefinition pd;
            if (!result.add(propId) || (pd = this.cache.get(propId)) == null) continue;
            String[] children = pd.getInverseIsA();
            Arrays.addAll(queue, (Object[][])new String[][]{children});
        }
        return result;
    }
}

