/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.arp.javautil.arrays.Arrays;
import org.drools.FactException;
import org.drools.StatefulSession;
import org.drools.event.WorkingMemoryEventListener;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.AbstractExecutionStrategy;
import org.protempa.AlgorithmSource;
import org.protempa.DeletedWorkingMemoryEventListener;
import org.protempa.ExecutionStrategyInitializationException;
import org.protempa.ExecutionStrategyShutdownException;
import org.protempa.JBossRuleCreator;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.ProtempaException;
import org.protempa.ValidateAlgorithmCheckedVisitor;
import org.protempa.WorkingMemoryFactStore;
import org.protempa.datastore.WorkingMemoryDataStores;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

class StatefulExecutionStrategy
extends AbstractExecutionStrategy {
    private static final Logger LOGGER = Logger.getLogger(StatefulExecutionStrategy.class.getName());
    private final File databasePath;
    private DataStore<String, WorkingMemoryFactStore> dataStore;
    private WorkingMemoryDataStores workingMemoryDataStores;
    private StatefulSession workingMemory;
    private final DeletedWorkingMemoryEventListener workingMemoryEventListener;
    private List<Proposition> propsToDelete;

    StatefulExecutionStrategy(AlgorithmSource algorithmSource, Query query) {
        super(algorithmSource, query);
        assert (query != null) : "query cannot be null";
        String dbPath = query.getDatabasePath();
        assert (dbPath != null) : "query.getDatabasePath() cannot return a null value";
        this.databasePath = new File(dbPath);
        this.workingMemoryEventListener = new DeletedWorkingMemoryEventListener();
    }

    @Override
    public void initialize(PropositionDefinitionCache cache) throws ExecutionStrategyInitializationException {
        this.createDataStoreManager(cache);
        super.initialize(cache);
        this.getOrCreateDataStore();
    }

    @Override
    public Iterator<Proposition> execute(String keyId, Iterator<? extends Proposition> objects) {
        this.getOrCreateWorkingMemoryInstance(keyId);
        this.updateWorkingMemory(keyId, objects);
        this.fireAllRules();
        this.cleanupAndPersistWorkingMemory(keyId);
        return this.getWorkingMemoryIterator();
    }

    @Override
    public void closeCurrentWorkingMemory() {
        this.workingMemory.dispose();
    }

    @Override
    public void shutdown() throws ExecutionStrategyShutdownException {
        ExecutionStrategyShutdownException exception1 = this.closeDataStore();
        ExecutionStrategyShutdownException exception2 = this.closeDataStoreManager();
        if (exception1 != null && exception2 != null) {
            exception1.addSuppressed(exception2);
            throw exception1;
        }
        if (exception1 != null) {
            throw exception1;
        }
        if (exception2 != null) {
            throw exception2;
        }
    }

    public DataStore<String, WorkingMemoryFactStore> getDataStore() {
        return this.dataStore;
    }

    @Override
    protected JBossRuleCreator newRuleCreator() throws ExecutionStrategyInitializationException {
        Collection propDefs;
        PropositionDefinitionCache cache;
        ValidateAlgorithmCheckedVisitor visitor = new ValidateAlgorithmCheckedVisitor(this.getAlgorithmSource());
        Query query = this.getQuery();
        switch (query.getQueryMode()) {
            case REPROCESS_RETRIEVE: 
            case REPROCESS_DELETE: {
                cache = new PropositionDefinitionCache(Collections.emptyList());
                propDefs = cache.getAll();
                break;
            }
            case REPROCESS_UPDATE: {
                String pId;
                cache = this.workingMemoryDataStores.getCache();
                String[] queryPropIds = this.getQuery().getPropositionIds();
                Set propIdsUpdate = cache.getAll().stream().map(elt -> elt.getPropositionId()).filter(propId -> !Arrays.contains((Object[])queryPropIds, (Object)propId)).collect(Collectors.toSet());
                LinkedList<String> propIdsQueue = new LinkedList<String>();
                Arrays.addAll(propIdsQueue, (Object[][])new String[][]{queryPropIds});
                Collection<PropositionDefinition> pDefsFromCache = cache.getAll();
                while ((pId = (String)propIdsQueue.poll()) != null) {
                    for (PropositionDefinition propDef2 : pDefsFromCache) {
                        Object[] children = propDef2.getChildren();
                        if (!Arrays.contains((Object[])children, (Object)pId)) continue;
                        propIdsQueue.add(propDef2.getId());
                        propIdsUpdate.remove(pId);
                    }
                }
                propDefs = pDefsFromCache.stream().filter(propDef -> propDef != null && !propIdsUpdate.contains(propDef.getPropositionId())).collect(Collectors.toList());
                cache = new PropositionDefinitionCache(propDefs);
                break;
            }
            case REPROCESS_CREATE: {
                cache = this.getCache();
                propDefs = new ArrayList<PropositionDefinition>(cache.getAll());
                Set propIdsInStore = this.workingMemoryDataStores.getCache().getAll().stream().map(elt -> elt.getPropositionId()).collect(Collectors.toSet());
                for (String propId2 : query.getPropositionIds()) {
                    if (!propIdsInStore.contains(propId2)) continue;
                    throw new ExecutionStrategyInitializationException("Proposition id " + propId2 + "already exists; if you want to update it, use the update query mode");
                }
                Iterator<PropositionDefinition> itr = propDefs.iterator();
                while (itr.hasNext()) {
                    PropositionDefinition propDef3 = itr.next();
                    if (propDef3 != null && !propIdsInStore.contains(propDef3.getPropositionId())) continue;
                    itr.remove();
                }
                cache = new PropositionDefinitionCache(propDefs);
                break;
            }
            case REPLACE: 
            case UPDATE: {
                cache = this.getCache();
                propDefs = cache.getAll();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected query mode " + (Object)((Object)query.getQueryMode())));
            }
        }
        try {
            visitor.visit(propDefs);
        }
        catch (ProtempaException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        JBossRuleCreator ruleCreator = new JBossRuleCreator(visitor.getAlgorithms(), this.getDerivationsBuilder(), cache);
        try {
            ruleCreator.visit(propDefs);
        }
        catch (ProtempaException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        return ruleCreator;
    }

    private void createDataStoreManager(PropositionDefinitionCache cache) throws ExecutionStrategyInitializationException {
        try {
            this.workingMemoryDataStores = new WorkingMemoryDataStores(this.databasePath.getParent(), cache);
        }
        catch (IOException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
    }

    private void getOrCreateDataStore() throws ExecutionStrategyInitializationException {
        try {
            String dbName = this.databasePath.getName();
            this.dataStore = this.workingMemoryDataStores.getDataStore(dbName);
            LOGGER.log(Level.FINE, "Opened data store {0}", this.databasePath.getPath());
        }
        catch (IOException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        if (this.getQuery().getQueryMode() == QueryMode.REPLACE) {
            this.dataStore.clear();
            LOGGER.log(Level.FINE, "Cleared data store {0}", this.databasePath.getPath());
        }
    }

    private void getOrCreateWorkingMemoryInstance(String keyId) {
        this.createWorkingMemory(keyId);
        this.workingMemory.addEventListener((WorkingMemoryEventListener)this.workingMemoryEventListener);
    }

    private void createWorkingMemory(String keyId) {
        this.workingMemory = this.getRuleBase().newStatefulSession(true);
        this.workingMemory.setGlobal("keyId", (Object)keyId);
    }

    private void updateWorkingMemory(String keyId, Iterator<?> objects) throws FactException {
        if (objects != null) {
            while (objects.hasNext()) {
                this.workingMemory.insert((Object)((Proposition)objects.next()));
            }
        }
        if (this.dataStore != null) {
            WorkingMemoryFactStore factStore = (WorkingMemoryFactStore)this.dataStore.get((Object)keyId);
            QueryMode queryMode = this.getQuery().getQueryMode();
            switch (queryMode) {
                case REPROCESS_DELETE: 
                case REPROCESS_UPDATE: {
                    factStore.removeAll(this.getQuery().getPropositionIds());
                }
                case REPROCESS_RETRIEVE: 
                case REPROCESS_CREATE: {
                    this.getDerivationsBuilder().reset(factStore.getForwardDerivations(), factStore.getBackwardDerivations());
                    for (Proposition prop : factStore.getPropositions()) {
                        this.workingMemory.insert((Object)prop);
                    }
                    break;
                }
                case REPLACE: 
                case UPDATE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected query mode " + (Object)((Object)queryMode)));
                }
            }
        }
    }

    private void fireAllRules() throws FactException {
        this.workingMemory.fireAllRules();
        this.propsToDelete = this.workingMemoryEventListener.getPropsToDelete();
    }

    private void cleanupAndPersistWorkingMemory(String keyId) {
        this.workingMemory.removeEventListener((WorkingMemoryEventListener)this.workingMemoryEventListener);
        this.workingMemoryEventListener.clear();
        LOGGER.log(Level.FINEST, "Persisting working memory for key ID {0}", keyId);
        WorkingMemoryFactStore factStore = new WorkingMemoryFactStore();
        factStore.setForwardDerivations(this.getDerivationsBuilder().getForwardDerivations());
        factStore.setBackwardDerivations(this.getDerivationsBuilder().getBackwardDerivations());
        ArrayList<Proposition> facts = new ArrayList<Proposition>();
        Iterator factItr = this.workingMemory.iterateObjects();
        while (factItr.hasNext()) {
            facts.add((Proposition)factItr.next());
        }
        factStore.setPropositions(facts);
        this.dataStore.put((Object)keyId, (Object)factStore);
        LOGGER.log(Level.FINEST, "Persisted working memory for key ID {0}", keyId);
    }

    private Iterator<Proposition> getWorkingMemoryIterator() {
        return new IteratorChain(this.workingMemory.iterateObjects(), this.propsToDelete.iterator());
    }

    private ExecutionStrategyShutdownException closeDataStore() {
        if (this.dataStore != null) {
            try {
                this.dataStore.close();
            }
            catch (IOError err) {
                return new ExecutionStrategyShutdownException(err);
            }
        }
        return null;
    }

    private ExecutionStrategyShutdownException closeDataStoreManager() {
        try {
            this.workingMemoryDataStores.close();
        }
        catch (IOException ex) {
            return new ExecutionStrategyShutdownException(ex);
        }
        return null;
    }
}

