/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.CycleDetectedException;
import org.protempa.PropositionDefinition;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPropositionDefinition;

class TopologicalSortComparator
implements Comparator<TemporalPropositionDefinition>,
Serializable {
    private static final long serialVersionUID = 924247928684751479L;
    private final Map<String, Integer> rule2Index = new HashMap<String, Integer>();

    TopologicalSortComparator(Collection<? extends PropositionDefinition> allNarrowerDescendants, Collection<? extends TemporalPropositionDefinition> abstractionDefinitions) throws CycleDetectedException {
        HashMap<String, PropositionDefinition> andMap = new HashMap<String, PropositionDefinition>();
        for (PropositionDefinition propositionDefinition : allNarrowerDescendants) {
            andMap.put(propositionDefinition.getId(), propositionDefinition);
        }
        HashMap nodes = new HashMap(abstractionDefinitions.size() * 4 / 3 + 1);
        HashSet<String> hashSet = new HashSet<String>();
        for (TemporalPropositionDefinition temporalPropositionDefinition : abstractionDefinitions) {
            hashSet.add(temporalPropositionDefinition.getId());
        }
        for (TemporalPropositionDefinition temporalPropositionDefinition : abstractionDefinitions) {
            if (temporalPropositionDefinition instanceof AbstractionDefinition) {
                AbstractionDefinition ad = (AbstractionDefinition)temporalPropositionDefinition;
                ArrayList<String> ads = new ArrayList<String>();
                for (String string : ad.getAbstractedFrom()) {
                    if (!hashSet.contains(string)) continue;
                    ads.add(string);
                }
                nodes.put(temporalPropositionDefinition.getId(), ads);
                continue;
            }
            if (!(temporalPropositionDefinition instanceof ContextDefinition)) continue;
            ContextDefinition cd = (ContextDefinition)temporalPropositionDefinition;
            ArrayList<String> ibs = new ArrayList<String>();
            for (TemporalExtendedPropositionDefinition tepd : cd.getInducedBy()) {
                String propId = tepd.getPropositionId();
                PropositionDefinition propDef = (PropositionDefinition)andMap.get(propId);
                if (!(propDef instanceof AbstractionDefinition) && !(propDef instanceof ContextDefinition)) continue;
                ibs.add(propId);
            }
            nodes.put(cd.getId(), ibs);
        }
        ArrayList<String> sortedAbstractions = new ArrayList<String>(nodes.size());
        HashSet<String> hashSet2 = new HashSet<String>();
        String[] zeroOutDegree = new String[nodes.size()];
        while (!nodes.isEmpty()) {
            hashSet2.clear();
            int pos = 0;
            for (Map.Entry entry : nodes.entrySet()) {
                String abstr = (String)entry.getKey();
                List neighbors = (List)entry.getValue();
                if (!neighbors.isEmpty()) continue;
                hashSet2.add(abstr);
                zeroOutDegree[pos++] = abstr;
            }
            if (hashSet2.isEmpty()) {
                throw new CycleDetectedException(nodes.keySet());
            }
            Arrays.sort(zeroOutDegree, 0, pos, null);
            for (int i = 0; i < pos; ++i) {
                sortedAbstractions.add(zeroOutDegree[i]);
            }
            for (List list : nodes.values()) {
                list.removeAll(hashSet2);
            }
            for (String string : hashSet2) {
                nodes.remove(string);
            }
        }
        for (int i = 0; i < sortedAbstractions.size(); ++i) {
            this.rule2Index.put((String)sortedAbstractions.get(i), i);
        }
    }

    @Override
    public int compare(TemporalPropositionDefinition a1, TemporalPropositionDefinition a2) {
        if (a1 == a2) {
            return 0;
        }
        Integer index1 = this.rule2Index.get(a1.getId());
        Integer index2 = this.rule2Index.get(a2.getId());
        return index1.compareTo(index2);
    }
}

