/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.BackendNewInstanceException;
import org.protempa.backend.BackendPropertySpec;
import org.protempa.backend.BackendProvider;

public final class BackendSpec<B extends Backend> {
    private static final BackendPropertySpec[] EMPTY_BACKEND_PROPERTY_SPEC_ARR = new BackendPropertySpec[0];
    private BackendProvider backendProvider;
    private String id;
    private String displayName;
    private final BackendPropertySpec[] propertySpecs;

    public BackendSpec(BackendProvider backendProvider, String id, String displayName, BackendPropertySpec[] propertySpecs) {
        if (backendProvider == null) {
            throw new IllegalArgumentException("backendProvider cannot be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id.contains("|")) {
            throw new IllegalArgumentException("id cannot have the | character");
        }
        this.id = id;
        this.backendProvider = backendProvider;
        this.displayName = displayName;
        this.propertySpecs = propertySpecs != null ? (BackendPropertySpec[])propertySpecs.clone() : EMPTY_BACKEND_PROPERTY_SPEC_ARR;
    }

    public String getId() {
        return this.id;
    }

    public BackendProvider getBackendProvider() {
        return this.backendProvider;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BackendPropertySpec[] getPropertySpecs() {
        return (BackendPropertySpec[])this.propertySpecs.clone();
    }

    public BackendInstanceSpec<B> newBackendInstanceSpec() {
        return new BackendInstanceSpec(this);
    }

    B newBackendInstance() throws BackendNewInstanceException {
        return (B)((Backend)this.backendProvider.newInstance(this.id));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

