/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.InvalidPropertyNameException;
import org.protempa.backend.annotations.BackendInfo;
import org.protempa.backend.annotations.BackendProperty;

public class CommonsBackend {
    public static BackendInfo backendInfo(Backend backend) {
        return backend.getClass().getAnnotation(BackendInfo.class);
    }

    public static String nameForErrors(Backend backend) {
        BackendInfo backendInfo = CommonsBackend.backendInfo(backend);
        if (backendInfo != null) {
            return backendInfo.displayName() + " (" + backend.getClass().getName() + ")";
        }
        return backend.getClass().getName();
    }

    public static void initialize(Object backend, BackendInstanceSpec backendInstanceSpec) {
        assert (backend != null) : "backend cannot be null";
        assert (backendInstanceSpec != null) : "backendInstanceSpec cannot be null";
        for (Method method : backend.getClass().getMethods()) {
            if (!method.isAnnotationPresent(BackendProperty.class)) continue;
            try {
                BackendProperty annotation = method.getAnnotation(BackendProperty.class);
                String propertyName = CommonsBackend.propertyName(annotation, method);
                Object propertyValue = backendInstanceSpec.getProperty(propertyName);
                if (propertyValue == null) continue;
                method.invoke(backend, propertyValue);
            }
            catch (IllegalAccessException | InvocationTargetException | InvalidPropertyNameException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    private static String propertyName(BackendProperty annotation, Method method) {
        String propertyName;
        String propertyNameInAnnotation = annotation.propertyName();
        if (propertyNameInAnnotation.isEmpty()) {
            String setterName = method.getName();
            propertyName = setterName.substring(3);
            char[] propertyNameArr = propertyName.toCharArray();
            propertyNameArr[0] = Character.toLowerCase(propertyNameArr[0]);
            propertyName = String.valueOf(propertyNameArr);
        } else {
            propertyName = propertyNameInAnnotation;
        }
        return propertyName;
    }
}

