/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import org.arp.javautil.serviceloader.SingletonServiceLoader;
import org.protempa.backend.Configurations;
import org.protempa.backend.ConfigurationsProvider;

public final class ConfigurationsProviderManager {
    private static ConfigurationsProvider configurationsProvider;
    private static ClassLoader configurationsProviderClassLoader;
    private static boolean configurationsProviderClassLoaderSpecified;

    public static void setConfigurationsProviderClassLoader(ClassLoader loader) {
        configurationsProviderClassLoader = loader;
        configurationsProviderClassLoaderSpecified = true;
    }

    public static ClassLoader getConfigurationsProviderClassLoader() {
        return configurationsProviderClassLoader;
    }

    public static boolean isConfigurationsProviderClassLoaderSpecified() {
        return configurationsProviderClassLoaderSpecified;
    }

    public static void setConfigurationsProvider(ConfigurationsProvider configurationsProvider) {
        ConfigurationsProviderManager.configurationsProvider = configurationsProvider;
    }

    public static ConfigurationsProvider getConfigurationsProvider() {
        ConfigurationsProviderManager.loadConfigurationsProviderIfNeeded();
        return configurationsProvider;
    }

    public static Configurations getConfigurations() {
        ConfigurationsProviderManager.loadConfigurationsProviderIfNeeded();
        return configurationsProvider.getConfigurations();
    }

    private static void loadConfigurationsProviderIfNeeded() {
        if (configurationsProvider == null) {
            configurationsProvider = configurationsProviderClassLoaderSpecified ? (ConfigurationsProvider)SingletonServiceLoader.load(ConfigurationsProvider.class, (ClassLoader)configurationsProviderClassLoader) : (ConfigurationsProvider)SingletonServiceLoader.load(ConfigurationsProvider.class);
        }
        if (configurationsProvider == null) {
            throw new IllegalStateException("No configurationsProvider found by service discovery or set with setConfigurationsProvider");
        }
    }
}

