/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.asb.java;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import org.arp.javautil.io.IOUtil;
import org.protempa.Algorithm;
import org.protempa.AlgorithmSourceReadException;
import org.protempa.Algorithms;
import org.protempa.backend.AlgorithmSourceBackendInitializationException;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.asb.AbstractAlgorithmSourceBackend;
import org.protempa.backend.asb.java.JavaAlgorithmUtil;

public abstract class AbstractJavaAlgorithmBackend
extends AbstractAlgorithmSourceBackend {
    private static final String DEFAULT_ALGORITHMS_PROPS = "/org/protempa/backend/asb/java/algorithms.properties";
    private final Properties algorithmClasses = new Properties();

    public AbstractJavaAlgorithmBackend() {
        this(null);
    }

    public AbstractJavaAlgorithmBackend(BackendInstanceSpec config) {
    }

    protected String getAlgorithmsPropertiesResourceName() {
        return DEFAULT_ALGORITHMS_PROPS;
    }

    @Override
    public final void initialize(BackendInstanceSpec config) throws BackendInitializationException {
        super.initialize(config);
        try {
            IOUtil.readPropertiesFromResource((Properties)this.algorithmClasses, this.getClass(), (String)this.getAlgorithmsPropertiesResourceName());
        }
        catch (IOException e) {
            throw new AlgorithmSourceBackendInitializationException("Could not initialize " + this.getClass(), e);
        }
    }

    @Override
    public final Algorithm readAlgorithm(String id, Algorithms algorithms) throws AlgorithmSourceReadException {
        String className = this.algorithmClasses.getProperty(id);
        if (className != null) {
            return this.createAlgorithmInstance(id, algorithms, className);
        }
        return null;
    }

    protected Class<?> getAlgorithmClass(String name) throws Exception {
        return Class.forName(name);
    }

    private final Algorithm createAlgorithmInstance(String id, Algorithms algorithms, String className) throws AlgorithmSourceReadException {
        Algorithm result = null;
        try {
            Class<?> c = this.getAlgorithmClass(className);
            if (c != null) {
                Constructor<?> con = c.getConstructor(Algorithms.class, String.class);
                if (con != null) {
                    result = (Algorithm)con.newInstance(algorithms, id);
                }
            } else {
                throw new AlgorithmSourceReadException("Could not find algorithm " + className);
            }
            JavaAlgorithmUtil.logger().fine("Created algorithm " + id);
        }
        catch (Exception e) {
            throw new AlgorithmSourceReadException("Could not find algorithm " + className, e);
        }
        return result;
    }

    @Override
    public final void readAlgorithms(Algorithms algorithms) throws AlgorithmSourceReadException {
        for (Map.Entry<Object, Object> e : this.algorithmClasses.entrySet()) {
            String algoId = (String)e.getKey();
            String algoClassName = (String)e.getValue();
            Algorithm algorithm = algorithms.getAlgorithm(algoId);
            if (algorithm != null) continue;
            algorithms.addAlgorithm(this.createAlgorithmInstance(algoId, algorithms, algoClassName));
        }
    }

    @Override
    public void close() {
        this.algorithmClasses.clear();
    }
}

