/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.filter;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.dsb.filter.AbstractFilter;
import org.protempa.backend.dsb.filter.FilterVisitor;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;

public class PositionFilter
extends AbstractFilter {
    private static final IntervalFactory intervalFactory = new IntervalFactory();
    private Long start;
    private Granularity startGran;
    private Long finish;
    Granularity finishGran;
    private Interval ival;
    private Interval.Side startSide;
    private Interval.Side finishSide;

    public PositionFilter(String[] propIds, Long start, Granularity startGran, Long finish, Granularity finishGran) {
        this(propIds, start, startGran, finish, finishGran, null, null);
    }

    public PositionFilter(String[] propIds, Long start, Granularity startGran, Long finish, Granularity finishGran, Interval.Side startSide, Interval.Side finishSide) {
        super(propIds);
        this.start = start;
        this.startGran = startGran;
        this.finish = finish;
        this.finishGran = finishGran;
        this.startSide = startSide;
        this.finishSide = finishSide;
        this.init();
    }

    private void init() {
        if (this.ival == null) {
            this.ival = intervalFactory.getInstance(this.start, this.startGran, this.finish, this.finishGran);
            if (this.startSide == null) {
                this.startSide = Interval.Side.START;
            }
            if (this.finishSide == null) {
                this.finishSide = Interval.Side.FINISH;
            }
        }
    }

    public Granularity getStartGranularity() {
        return this.startGran;
    }

    public Granularity getFinishGranularity() {
        return this.finishGran;
    }

    public Long getMaximumFinish() {
        return this.ival.getMaximumFinish();
    }

    public Long getMaximumStart() {
        return this.ival.getMaximumStart();
    }

    public Long getMinimumFinish() {
        return this.ival.getMinimumFinish();
    }

    public Long getMinimumStart() {
        return this.ival.getMinimumStart();
    }

    public Long getStart() {
        return this.start;
    }

    public Long getFinish() {
        return this.finish;
    }

    public Interval.Side getStartSide() {
        return this.startSide;
    }

    public Interval.Side getFinishSide() {
        return this.finishSide;
    }

    @Override
    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.finish == null ? 0 : this.finish.hashCode());
        result = 31 * result + (this.finishGran == null ? 0 : this.finishGran.hashCode());
        result = 31 * result + (this.finishSide == null ? 0 : this.finishSide.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.startGran == null ? 0 : this.startGran.hashCode());
        result = 31 * result + (this.startSide == null ? 0 : this.startSide.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionFilter other = (PositionFilter)obj;
        if (this.finish == null ? other.finish != null : !this.finish.equals(other.finish)) {
            return false;
        }
        if (this.finishGran == null ? other.finishGran != null : !this.finishGran.equals(other.finishGran)) {
            return false;
        }
        if (this.finishSide != other.finishSide) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        if (this.startGran == null ? other.startGran != null : !this.startGran.equals(other.startGran)) {
            return false;
        }
        return this.startSide == other.startSide;
    }
}

