/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.filter;

import java.util.Arrays;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.dsb.filter.AbstractFilter;
import org.protempa.backend.dsb.filter.FilterVisitor;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;

public class PropertyValueFilter
extends AbstractFilter {
    private final String property;
    private final ValueComparator valueComparator;
    private final Value[] values;

    public PropertyValueFilter(String[] propositionIds, String property, ValueComparator valueComparator, Value ... values) {
        super(propositionIds);
        if (property == null) {
            throw new IllegalArgumentException("property cannot be null");
        }
        if (valueComparator == null) {
            throw new IllegalArgumentException("valueComparator cannot be null");
        }
        if (valueComparator == ValueComparator.UNKNOWN) {
            throw new IllegalArgumentException("Cannot use UNKNOWN value comparator here");
        }
        if (values.length > 1 && valueComparator != ValueComparator.IN && valueComparator != ValueComparator.NOT_IN) {
            throw new IllegalArgumentException("Multiple value arguments are only allowed if the value comparator is IN or NOT_IN");
        }
        for (Value val : values) {
            if (!(val instanceof ValueList)) continue;
            throw new IllegalArgumentException("values connnot contain any ListValues");
        }
        this.property = property.intern();
        this.valueComparator = valueComparator;
        this.values = (Value[])values.clone();
    }

    public String getProperty() {
        return this.property;
    }

    public Value[] getValues() {
        return (Value[])this.values.clone();
    }

    public ValueComparator getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.valueComparator == null ? 0 : this.valueComparator.hashCode());
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyValueFilter other = (PropertyValueFilter)obj;
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        if (this.valueComparator != other.valueComparator) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }
}

