/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.deid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.PropositionDefinitionCache;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.QueryResultsHandlerValidationFailedException;
import org.protempa.dest.deid.DeidConfig;
import org.protempa.dest.deid.EncryptException;
import org.protempa.dest.deid.Encryption;
import org.protempa.dest.deid.EncryptionInitException;
import org.protempa.dest.deid.PropositionDeidentifierVisitor;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public final class DeidentifiedQueryResultsHandler
extends AbstractQueryResultsHandler {
    private static final Logger LOGGER = Logger.getLogger(DeidentifiedQueryResultsHandler.class.getName());
    private final Encryption encryption;
    private final QueryResultsHandler handler;
    private final DeidConfig deidConfig;
    private final String id;
    private boolean handlerClosed;
    private PropositionDefinitionCache propDefCache;

    DeidentifiedQueryResultsHandler(QueryResultsHandler handler, DeidConfig deidConfig) throws EncryptionInitException {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        this.handler = handler;
        this.deidConfig = deidConfig;
        this.encryption = deidConfig.getEncryptionInstance();
        this.id = this.handler.getId() + " with deidentification";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void validate() throws QueryResultsHandlerValidationFailedException {
        this.handler.validate();
    }

    @Override
    public void start(PropositionDefinitionCache cache) throws QueryResultsHandlerProcessingException {
        this.propDefCache = cache;
        this.handler.start(cache);
    }

    @Override
    public void handleQueryResult(String keyId, List<Proposition> propositions, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        String encryptedKeyId;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Deidentifying data");
        }
        try {
            encryptedKeyId = this.encryption.encrypt(keyId, keyId);
        }
        catch (EncryptException ex) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Could not encrypt keyId");
            }
            throw new QueryResultsHandlerProcessingException("Could not encrypt keyId", ex);
        }
        HashMap<UniqueId, Proposition> deidentifiedPropsByUniqueId = new HashMap<UniqueId, Proposition>();
        ArrayList<Proposition> deidentifiedProps = new ArrayList<Proposition>(propositions.size());
        HashMap<UniqueId, Proposition> deidentifiedReferences = new HashMap<UniqueId, Proposition>();
        HashMap<Proposition, Set<Proposition>> deidentifiedForwardDerivations = new HashMap<Proposition, Set<Proposition>>();
        HashMap<Proposition, Set<Proposition>> deidentifiedBackwardDerivations = new HashMap<Proposition, Set<Proposition>>();
        try {
            Proposition prop;
            HashSet<Proposition> values;
            Proposition key;
            PropositionDeidentifierVisitor visitor = new PropositionDeidentifierVisitor(this.encryption, this.propDefCache, this.deidConfig.getOffset(keyId));
            visitor.setKeyId(keyId);
            for (Proposition proposition : propositions) {
                proposition.accept(visitor);
                Proposition deidentifiedProposition = visitor.getProposition();
                deidentifiedProps.add(deidentifiedProposition);
                deidentifiedPropsByUniqueId.put(deidentifiedProposition.getUniqueId(), deidentifiedProposition);
            }
            for (Map.Entry entry : references.entrySet()) {
                Proposition prop3 = (Proposition)deidentifiedPropsByUniqueId.get(entry.getKey());
                if (prop3 == null) {
                    ((Proposition)entry.getValue()).accept(visitor);
                    prop3 = visitor.getProposition();
                    deidentifiedPropsByUniqueId.put(prop3.getUniqueId(), prop3);
                }
                deidentifiedReferences.put(prop3.getUniqueId(), prop3);
            }
            for (Map.Entry entry : forwardDerivations.entrySet()) {
                key = (Proposition)deidentifiedPropsByUniqueId.get(((Proposition)entry.getKey()).getUniqueId());
                if (key == null) {
                    ((Proposition)entry.getKey()).accept(visitor);
                    key = visitor.getProposition();
                    deidentifiedPropsByUniqueId.put(key.getUniqueId(), key);
                }
                values = new HashSet<Proposition>();
                for (Proposition val : (Set)entry.getValue()) {
                    prop = (Proposition)deidentifiedPropsByUniqueId.get(val.getUniqueId());
                    if (prop == null) {
                        ((Proposition)entry.getKey()).accept(visitor);
                        prop = visitor.getProposition();
                        deidentifiedPropsByUniqueId.put(prop.getUniqueId(), prop);
                    }
                    values.add(prop);
                }
                deidentifiedForwardDerivations.put(key, values);
            }
            for (Map.Entry entry : backwardDerivations.entrySet()) {
                key = (Proposition)deidentifiedPropsByUniqueId.get(((Proposition)entry.getKey()).getUniqueId());
                if (key == null) {
                    ((Proposition)entry.getKey()).accept(visitor);
                    key = visitor.getProposition();
                    deidentifiedPropsByUniqueId.put(key.getUniqueId(), key);
                }
                values = new HashSet();
                for (Proposition val : (Set)entry.getValue()) {
                    prop = (Proposition)deidentifiedPropsByUniqueId.get(val.getUniqueId());
                    if (prop == null) {
                        ((Proposition)entry.getKey()).accept(visitor);
                        prop = visitor.getProposition();
                        deidentifiedPropsByUniqueId.put(prop.getUniqueId(), prop);
                    }
                    values.add(prop);
                }
                deidentifiedBackwardDerivations.put(key, values);
            }
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Something happened");
            }
            LOGGER.log(Level.SEVERE, "Error occurred", t);
            throw t;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Data deidentified");
        }
        this.handler.handleQueryResult(encryptedKeyId, deidentifiedProps, deidentifiedForwardDerivations, deidentifiedBackwardDerivations, deidentifiedReferences);
    }

    @Override
    public void finish() throws QueryResultsHandlerProcessingException {
        this.handler.finish();
    }

    @Override
    public void close() throws QueryResultsHandlerCloseException {
        try {
            this.handler.close();
            this.handlerClosed = true;
        }
        finally {
            block8: {
                try {
                    this.deidConfig.close();
                }
                catch (Exception ex) {
                    if (!this.handlerClosed) break block8;
                    throw new QueryResultsHandlerCloseException("Error cleaning up deidentification state");
                }
            }
        }
    }

    @Override
    public void cancel() {
        this.handler.cancel();
    }
}

