/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Value;

public final class Derivation
extends Link {
    private static final Value[] EMPTY_VALUE_ARRAY = new Value[0];
    private final Behavior behavior;
    private final Value[] allowedValues;
    private Set<String> knowledgeTree;
    private final Relation relation;
    private final Queue<Proposition> internalDerived;

    public Derivation(String[] propositionIds, Behavior behavior) {
        this(propositionIds, null, null, behavior, null);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Behavior behavior) {
        this(propositionIds, constraints, null, -1, -1, null, behavior, null);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Value[] allowedValues, Behavior behavior) throws KnowledgeSourceReadException {
        this(propositionIds, constraints, null, -1, -1, allowedValues, behavior, null);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Value[] allowedValues, Behavior behavior, Relation relation) {
        this(propositionIds, constraints, null, -1, -1, allowedValues, behavior, relation);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int index, Behavior behavior) throws KnowledgeSourceReadException {
        this(propositionIds, constraints, comparator, index, index >= 0 ? index + 1 : -1, null, behavior, null);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int index, Value[] allowedValues, Behavior behavior) {
        this(propositionIds, constraints, comparator, index, index >= 0 ? index + 1 : -1, allowedValues, behavior, null);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int fromIndex, int toIndex, Behavior behavior) throws KnowledgeSourceReadException {
        this(propositionIds, constraints, comparator, fromIndex, toIndex, null, behavior, null);
    }

    public Derivation(String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int fromIndex, int toIndex, Value[] allowedValues, Behavior behavior, Relation relation) {
        super(propositionIds, constraints, comparator, fromIndex, toIndex);
        this.allowedValues = allowedValues == null ? EMPTY_VALUE_ARRAY : (Value[])allowedValues.clone();
        if (behavior == null) {
            throw new IllegalArgumentException("behavior cannot be null");
        }
        this.behavior = behavior;
        this.relation = relation;
        this.internalDerived = new LinkedList<Proposition>();
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        String[] explicitPropIds = this.getPropositionIds();
        if (explicitPropIds.length > 0) {
            return explicitPropIds;
        }
        HashSet result = new HashSet();
        block6: for (PropositionDefinition propDef : knowledgeSource.readPropositionDefinitions(inPropIds)) {
            switch (this.behavior) {
                case SINGLE_BACKWARD: {
                    org.arp.javautil.arrays.Arrays.addAll(result, (Object[][])new String[][]{propDef.getChildren()});
                    break;
                }
                case MULT_BACKWARD: {
                    String pId;
                    LinkedList backwardProps = new LinkedList();
                    org.arp.javautil.arrays.Arrays.addAll(backwardProps, (Object[][])new String[][]{propDef.getChildren()});
                    while ((pId = (String)backwardProps.poll()) != null) {
                        PropositionDefinition pDef = knowledgeSource.readPropositionDefinition(pId);
                        org.arp.javautil.arrays.Arrays.addAll(backwardProps, (Object[][])new String[][]{pDef.getChildren()});
                    }
                    result.addAll(backwardProps);
                    break;
                }
                case SINGLE_FORWARD: {
                    for (PropositionDefinition propositionDefinition : knowledgeSource.readParents(propDef)) {
                        result.add(propositionDefinition.getId());
                    }
                    continue block6;
                }
                case MULT_FORWARD: {
                    String pId;
                    LinkedList<String> forwardProps = new LinkedList<String>();
                    for (PropositionDefinition def2 : knowledgeSource.readParents(propDef)) {
                        forwardProps.add(def2.getId());
                    }
                    while ((pId = (String)forwardProps.poll()) != null) {
                        PropositionDefinition propositionDefinition = knowledgeSource.readPropositionDefinition(pId);
                        for (PropositionDefinition def3 : knowledgeSource.readParents(propositionDefinition)) {
                            forwardProps.add(def3.getId());
                        }
                    }
                    result.addAll(forwardProps);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Invalid derivation behavior specified");
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    String headerFragment() {
        return this.createHeaderFragment("derived");
    }

    @Override
    Collection<Proposition> traverse(Proposition proposition, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache, Set<Proposition> cache) {
        ArrayList<Proposition> derived = null;
        switch (this.behavior) {
            case SINGLE_FORWARD: {
                derived = this.filterMatches(proposition, (Collection<Proposition>)forwardDerivations.get(proposition), cache);
                break;
            }
            case SINGLE_BACKWARD: {
                derived = this.filterMatches(proposition, (Collection<Proposition>)backwardDerivations.get(proposition), cache);
                break;
            }
            case MULT_FORWARD: {
                this.populateKnowledgeTree(ksCache);
                if (!this.knowledgeTree.contains(proposition.getId())) break;
                derived = new ArrayList();
                this.internalDerived.add(proposition);
                while (!this.internalDerived.isEmpty()) {
                    Proposition prop = this.internalDerived.remove();
                    Collection c = forwardDerivations.get(prop);
                    if (c == null) continue;
                    for (Proposition p : c) {
                        if (!cache.add(p)) continue;
                        this.internalDerived.add(p);
                        if (!this.isMatch(p) || !this.hasAllowedValue(p)) continue;
                        derived.add(p);
                    }
                }
                break;
            }
            case MULT_BACKWARD: {
                derived = new ArrayList();
                this.internalDerived.add(proposition);
                while (!this.internalDerived.isEmpty()) {
                    Proposition prop = this.internalDerived.remove();
                    Collection c = backwardDerivations.get(prop);
                    if (c == null) continue;
                    for (Proposition p : c) {
                        if (!cache.add(p)) continue;
                        this.internalDerived.add(p);
                        if (!this.isMatch(p) || !this.hasAllowedValue(p)) continue;
                        derived.add(p);
                    }
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected behavior: " + (Object)((Object)this.behavior)));
            }
        }
        this.internalDerived.clear();
        return this.createResults(derived);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void populateKnowledgeTree(KnowledgeSourceCache ksCache) {
        if (this.knowledgeTree == null) {
            String propId;
            this.knowledgeTree = new HashSet<String>();
            LinkedList queue = new LinkedList();
            org.arp.javautil.arrays.Arrays.addAll(queue, (Object[][])new String[][]{this.getPropositionIds()});
            while ((propId = (String)queue.poll()) != null) {
                PropositionDefinition propDef = ksCache.get(propId);
                if (propDef != null) {
                    if (propDef.getInDataSource()) {
                        this.knowledgeTree.add(propDef.getId());
                    }
                    org.arp.javautil.arrays.Arrays.addAll(queue, (Object[][])new String[][]{propDef.getChildren()});
                    continue;
                }
                throw new AssertionError((Object)("Invalid proposition definition " + propId));
            }
        }
    }

    private boolean hasAllowedValue(Proposition proposition) {
        if (this.allowedValues.length == 0) {
            return true;
        }
        return proposition instanceof Parameter && org.arp.javautil.arrays.Arrays.contains((Object[])this.allowedValues, (Object)((Parameter)proposition).getValue());
    }

    private List<Proposition> filterMatches(Proposition inProposition, Collection<Proposition> propositions, Set<Proposition> cache) {
        TemporalProposition inTp = null;
        if (this.relation != null && inProposition instanceof TemporalProposition) {
            inTp = (TemporalProposition)inProposition;
        }
        ArrayList<Proposition> result = new ArrayList<Proposition>();
        if (propositions != null) {
            for (Proposition proposition : propositions) {
                TemporalProposition tp;
                if (!cache.add(proposition) || !this.isMatch(proposition) || !this.hasAllowedValue(proposition) || inTp != null && proposition instanceof TemporalProposition && !this.relation.hasRelation((tp = (TemporalProposition)proposition).getInterval(), inTp.getInterval())) continue;
                result.add(proposition);
            }
        }
        return result;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public Value[] getAllowedValues() {
        return this.allowedValues;
    }

    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.allowedValues);
        result = 31 * result + (this.behavior == null ? 0 : this.behavior.hashCode());
        result = 31 * result + (this.knowledgeTree == null ? 0 : this.knowledgeTree.hashCode());
        result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Derivation other = (Derivation)obj;
        if (!Arrays.equals(this.allowedValues, other.allowedValues)) {
            return false;
        }
        if (this.behavior != other.behavior) {
            return false;
        }
        if (this.knowledgeTree == null ? other.knowledgeTree != null : !this.knowledgeTree.equals(other.knowledgeTree)) {
            return false;
        }
        return !(this.relation == null ? other.relation != null : !this.relation.equals(other.relation));
    }

    public static enum Behavior {
        SINGLE_FORWARD,
        SINGLE_BACKWARD,
        MULT_FORWARD,
        MULT_BACKWARD;

    }
}

