/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.ProtempaUtil;
import org.protempa.dest.table.AbstractTableColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkValidationFailedException;
import org.protempa.dest.table.TableColumnSpecValidationFailedException;
import org.protempa.dest.table.TabularWriter;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.dest.table.Util;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalParameter;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.comparator.AllPropositionIntervalComparator;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.NumericalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

public class PropositionValueColumnSpec
extends AbstractTableColumnSpec {
    private static final Comparator<? super Proposition> comp = new AllPropositionIntervalComparator();
    private static final Comparator<? super Proposition> reverseComp = Collections.reverseOrder(comp);
    private final Link[] links;
    private final String columnNamePrefixOverride;
    private Type type;

    public PropositionValueColumnSpec(Link[] links, Type aggregationType) {
        this(null, links, aggregationType);
    }

    public PropositionValueColumnSpec(String columnNamePrefixOverride, Link[] links, Type aggregationType) {
        if (links == null) {
            this.links = Util.EMPTY_LINK_ARRAY;
        } else {
            ProtempaUtil.checkArrayForNullElement(links, "links");
            this.links = (Link[])links.clone();
        }
        if (aggregationType == null) {
            throw new IllegalArgumentException("aggregationType cannot be null");
        }
        this.type = aggregationType;
        this.columnNamePrefixOverride = columnNamePrefixOverride;
    }

    @Override
    public void columnValues(String key, Proposition proposition, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache, TabularWriter writer) throws TabularWriterException {
        List<Proposition> propositions = this.traverseLinks(this.links, proposition, forwardDerivations, backwardDerivations, references, ksCache);
        Value value = null;
        BigDecimal sumTotal = null;
        BigInteger count = BigInteger.ZERO;
        ArrayList<NumberValue> orderStats = new ArrayList<NumberValue>();
        if (propositions.size() > 1) {
            switch (this.type) {
                case FIRST: {
                    propositions = new ArrayList<Proposition>(propositions);
                    Collections.sort(propositions, comp);
                    break;
                }
                case LAST: {
                    propositions = new ArrayList<Proposition>(propositions);
                    Collections.sort(propositions, reverseComp);
                    break;
                }
                case SUM: 
                case AVG: 
                case MEDIAN: 
                case MIN: 
                case MAX: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid aggregation type " + (Object)((Object)this.type)));
                }
            }
        }
        block27: for (Proposition prop : propositions) {
            if (prop instanceof TemporalParameter) {
                TemporalParameter pp = (TemporalParameter)prop;
                Value val = pp.getValue();
                if (val == null) continue;
                switch (this.type) {
                    case MIN: 
                    case MAX: {
                        if (ValueType.NUMERICALVALUE.isInstance(val)) break;
                        continue block27;
                    }
                    case SUM: 
                    case AVG: 
                    case MEDIAN: {
                        if (ValueType.NUMBERVALUE.isInstance(val)) break;
                        continue block27;
                    }
                    case FIRST: 
                    case LAST: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Invalid aggregation type " + (Object)((Object)this.type)));
                    }
                }
                if (value == null && sumTotal == null) {
                    switch (this.type) {
                        case FIRST: 
                        case LAST: {
                            value = val;
                            break block27;
                        }
                        case MEDIAN: {
                            orderStats.add((NumberValue)val);
                            continue block27;
                        }
                        case AVG: {
                            count = BigInteger.ONE;
                        }
                        case SUM: {
                            sumTotal = ((NumberValue)val).getBigDecimal();
                            continue block27;
                        }
                        case MIN: 
                        case MAX: {
                            value = val;
                            continue block27;
                        }
                        default: {
                            throw new AssertionError((Object)("Invalid aggregation type " + (Object)((Object)this.type)));
                        }
                    }
                }
                switch (this.type) {
                    case MAX: {
                        ValueComparator c = val.compare(value);
                        if (c.includes(ValueComparator.UNKNOWN)) {
                            c = ((NumericalValue)val).getNumberValue().compare(((NumericalValue)value).getNumberValue());
                        }
                        if (!c.includes(ValueComparator.GREATER_THAN)) continue block27;
                        value = val;
                        break;
                    }
                    case MIN: {
                        ValueComparator c = val.compare(value);
                        if (c.includes(ValueComparator.UNKNOWN)) {
                            c = ((NumericalValue)val).getNumberValue().compare(((NumericalValue)value).getNumberValue());
                        }
                        if (!c.includes(ValueComparator.LESS_THAN)) continue block27;
                        value = val;
                        break;
                    }
                    case MEDIAN: {
                        orderStats.add((NumberValue)val);
                        break;
                    }
                    case AVG: {
                        count.add(BigInteger.ONE);
                    }
                    case SUM: {
                        try {
                            sumTotal = sumTotal.add(((NumberValue)val).getBigDecimal());
                            break;
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalStateException("only number values allowed for SUM or AVG aggregation type; got " + val + " for proposition " + pp.getId() + " instead");
                        }
                    }
                    case FIRST: 
                    case LAST: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Invalid aggregation type " + (Object)((Object)this.type)));
                    }
                }
                continue;
            }
            throw new IllegalStateException("Only temporal parameters allowed");
        }
        if (sumTotal != null) {
            if (this.type == Type.AVG) {
                writer.writeNumber(NumberValue.getInstance(sumTotal.divide(BigDecimal.valueOf(count.longValue()))));
            } else {
                writer.writeNumber(NumberValue.getInstance(sumTotal));
            }
        } else if (this.type == Type.MEDIAN) {
            NumberValue median = this.medianValue(orderStats);
            if (median != null) {
                writer.writeString(median.getFormatted());
            } else {
                writer.writeNull();
            }
        } else if (value != null) {
            writer.writeString(value.getFormatted());
        } else {
            writer.writeNull();
        }
    }

    private NumberValue medianValue(List<NumberValue> values) {
        Collections.sort(values);
        if (values.size() == 0) {
            return null;
        }
        if (values.size() % 2 == 1) {
            return values.get((1 + values.size()) / 2);
        }
        NumberValue median1 = values.get(values.size() / 2);
        NumberValue median2 = values.get(values.size() / 2 + 1);
        return NumberValue.getInstance(median1.getBigDecimal().add(median2.getBigDecimal()).divide(BigDecimal.valueOf(2L)));
    }

    @Override
    public String[] columnNames(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        String headerString = this.columnNamePrefixOverride != null ? this.columnNamePrefixOverride : this.generateLinksHeaderString(this.links) + (this.type == Type.MIN ? "_min" : "_max");
        return new String[]{headerString};
    }

    @Override
    public void validate(KnowledgeSource knowledgeSource) throws TableColumnSpecValidationFailedException, KnowledgeSourceReadException {
        int i = 1;
        for (Link link : this.links) {
            try {
                link.validate(knowledgeSource);
            }
            catch (LinkValidationFailedException ex) {
                throw new TableColumnSpecValidationFailedException("Validation of link " + i + " failed", ex);
            }
            ++i;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Link[] getLinks() {
        return this.links;
    }

    public String getColumnNamePrefixOverride() {
        return this.columnNamePrefixOverride;
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        HashSet result = new HashSet();
        for (Link link : this.links) {
            inPropIds = link.getInferredPropositionIds(knowledgeSource, inPropIds);
            org.arp.javautil.arrays.Arrays.addAll(result, (Object[][])new String[][]{inPropIds});
        }
        return result.toArray(new String[result.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnNamePrefixOverride == null ? 0 : this.columnNamePrefixOverride.hashCode());
        result = 31 * result + Arrays.hashCode(this.links);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropositionValueColumnSpec other = (PropositionValueColumnSpec)obj;
        if (this.columnNamePrefixOverride == null ? other.columnNamePrefixOverride != null : !this.columnNamePrefixOverride.equals(other.columnNamePrefixOverride)) {
            return false;
        }
        if (!Arrays.equals(this.links, other.links)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type {
        MAX,
        MIN,
        FIRST,
        LAST,
        SUM,
        AVG,
        MEDIAN;

    }
}

