/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.DataSourceBackendId;
import org.protempa.proposition.DerivedSourceId;
import org.protempa.proposition.LocalUniqueId;
import org.protempa.proposition.SourceId;

public final class UniqueId
implements Serializable {
    private static final long serialVersionUID = 396847781133676191L;
    private SourceId sourceId;
    private LocalUniqueId localUniqueId;
    private volatile transient int hashCode;

    public UniqueId(UniqueId other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        this.sourceId = other.sourceId;
        this.localUniqueId = other.localUniqueId;
    }

    public UniqueId(SourceId newSourceId, LocalUniqueId localUniqueId) {
        if (newSourceId == null) {
            throw new IllegalArgumentException("dataSourceBackendId cannot be null");
        }
        if (localUniqueId == null) {
            throw new IllegalArgumentException("localUniqueId cannot be null");
        }
        this.sourceId = newSourceId;
        this.localUniqueId = localUniqueId.clone();
    }

    public SourceId getSourceId() {
        return this.sourceId;
    }

    public LocalUniqueId getLocalUniqueId() {
        return this.localUniqueId;
    }

    public String getStringRepresentation() {
        return this.sourceId.getId() + "^" + this.localUniqueId.getId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueId other = (UniqueId)obj;
        if (!this.sourceId.equals(other.sourceId)) {
            return false;
        }
        return this.localUniqueId.equals(other.localUniqueId);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.localUniqueId.hashCode();
            this.hashCode = result = 104743 * result + this.sourceId.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        boolean derived = this.sourceId instanceof DerivedSourceId;
        s.writeBoolean(derived);
        if (!derived) {
            s.writeObject(this.sourceId.getId());
        }
        s.writeObject(this.localUniqueId);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (s.readBoolean()) {
            this.sourceId = DerivedSourceId.getInstance();
        } else {
            String id = (String)s.readObject();
            if (id == null) {
                throw new InvalidObjectException("Can't restore. Null id");
            }
            this.sourceId = DataSourceBackendId.getInstance(id);
        }
        this.localUniqueId = (LocalUniqueId)s.readObject();
    }
}

