/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.text.Format;
import org.protempa.proposition.value.RelativeTimeUnitFormat;
import org.protempa.proposition.value.Unit;

public abstract class AbstractTimeUnit
implements Unit {
    private static final long serialVersionUID = 1592143864041255117L;
    private transient String name;
    private transient String pluralName;
    private transient String abbreviation;
    private transient long length;
    private transient int calUnits;
    private transient Format shortFormat;
    private transient Format mediumFormat;
    private transient Format longFormat;

    AbstractTimeUnit(String name, String pluralName, String abbreviation, String shortFormat, String mediumFormat, String longFormat, long length, int calUnits) {
        this.name = name;
        this.pluralName = pluralName;
        this.abbreviation = abbreviation;
        this.length = length;
        this.calUnits = calUnits;
        this.shortFormat = new RelativeTimeUnitFormat(this, length, shortFormat);
        this.mediumFormat = new RelativeTimeUnitFormat(this, length, mediumFormat);
        this.longFormat = new RelativeTimeUnitFormat(this, length, longFormat);
    }

    @Override
    public String getPluralName() {
        return this.pluralName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbbreviatedName() {
        return this.abbreviation;
    }

    protected long getLength() {
        return this.length;
    }

    public int getCalendarUnits() {
        return this.calUnits;
    }

    @Override
    public Format getLongFormat() {
        return this.longFormat;
    }

    @Override
    public Format getMediumFormat() {
        return this.mediumFormat;
    }

    @Override
    public Format getShortFormat() {
        return this.shortFormat;
    }

    public String toString() {
        return this.name;
    }
}

