/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.ObjectStreamException;
import java.text.Format;
import java.util.ResourceBundle;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.RelativeDayUnit;
import org.protempa.proposition.value.RelativeTimeGranularityFormat;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.ValueUtil;

public class RelativeDayGranularity
implements Granularity {
    private static final long serialVersionUID = -6754830065091052862L;
    private static final ResourceBundle resourceBundle = ValueUtil.resourceBundle();
    private static String[] ABBREV_NAMES = new String[]{resourceBundle.getString("rel_time_field_abbrev_day")};
    private static String[] NAMES = new String[]{resourceBundle.getString("rel_time_field_singular_day")};
    private static final String[] PLURAL_NAMES = new String[]{resourceBundle.getString("rel_time_field_plural_day")};
    private static final String[] longRelativeTimeFormats = new String[]{resourceBundle.getString("long_rel_time_format_gran_day")};
    private static final String[] mediumRelativeTimeFormats = new String[]{resourceBundle.getString("med_rel_time_format_gran_day")};
    private static String[] shortRelativeTimeFormats = new String[]{resourceBundle.getString("short_rel_time_format_gran_day")};
    private static final int[] CALENDAR_TIME_UNITS = new int[]{5};
    public static final RelativeDayGranularity DAY = new RelativeDayGranularity(NAMES[0], PLURAL_NAMES[0], ABBREV_NAMES[0], shortRelativeTimeFormats[0], mediumRelativeTimeFormats[0], longRelativeTimeFormats[0], 1L, CALENDAR_TIME_UNITS[0]);
    private static final RelativeDayGranularity[] VALUES = new RelativeDayGranularity[]{DAY};
    private static int nextOrdinal = 0;
    private final transient String pluralName;
    private final transient String name;
    private final transient String abbreviation;
    private final transient Format longFormat;
    private final transient Format mediumFormat;
    private final transient Format shortFormat;
    private transient long length;
    private transient int calUnits;
    private int ordinal = nextOrdinal++;

    private RelativeDayGranularity(String name, String pluralName, String abbreviation, String shortFormat, String mediumFormat, String longFormat, long length, int calUnits) {
        this.name = name;
        this.pluralName = pluralName;
        this.abbreviation = abbreviation;
        this.length = length;
        this.shortFormat = new RelativeTimeGranularityFormat(this, 1L, shortFormat);
        this.mediumFormat = new RelativeTimeGranularityFormat(this, 1L, mediumFormat);
        this.longFormat = new RelativeTimeGranularityFormat(this, 1L, longFormat);
        this.calUnits = calUnits;
    }

    @Override
    public String getPluralName() {
        return this.pluralName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbbrevatedName() {
        return this.abbreviation;
    }

    @Override
    public Format getLongFormat() {
        return this.longFormat;
    }

    @Override
    public Format getMediumFormat() {
        return this.mediumFormat;
    }

    @Override
    public Format getShortFormat() {
        return this.shortFormat;
    }

    public long getLength() {
        return this.length;
    }

    public int getCalendarUnits() {
        return this.calUnits;
    }

    public long lengthInBaseUnit(long length) {
        return length * this.length;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    @Override
    public long earliest(long pos) {
        return pos;
    }

    @Override
    public long latest(long pos) {
        return pos + this.length - 1L;
    }

    @Override
    public long maximumDistance(long position, long distance, Unit distanceUnit) {
        long d = distance * this.length;
        return distance == 0L ? 0L : d + this.length - 1L;
    }

    @Override
    public long minimumDistance(long position, long distance, Unit distanceUnit) {
        long d = distance * this.length;
        return distance == 0L ? 0L : d - this.length + 1L;
    }

    @Override
    public long distance(long start, long finish, Granularity finishGranularity, Unit distanceUnit) {
        return (finish - start) / this.length;
    }

    @Override
    public int compareTo(Granularity o) {
        RelativeDayGranularity rdg = (RelativeDayGranularity)o;
        return 0;
    }

    @Override
    public Unit getCorrespondingUnit() {
        return RelativeDayUnit.DAY;
    }

    public int hashCode() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativeDayGranularity other = (RelativeDayGranularity)obj;
        return this.ordinal == other.ordinal;
    }
}

