/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.arp.javautil.arrays.Arrays;
import org.protempa.AlgorithmSource;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.query.Query;
import org.protempa.query.QueryBuildException;
import org.protempa.query.QueryBuilder;
import org.protempa.query.QueryMode;
import org.protempa.query.QueryValidationException;

public class DefaultQueryBuilder
implements QueryBuilder,
Serializable {
    private static final long serialVersionUID = -3920993703423486485L;
    private static final PropositionDefinition[] EMPTY_PROP_DEF_ARRAY = new PropositionDefinition[0];
    private static boolean validatePropositionIds = true;
    private String[] keyIds;
    private Filter filters;
    private String[] propIds;
    private PropositionDefinition[] propDefs = EMPTY_PROP_DEF_ARRAY;
    private String name;
    private String username;
    private QueryMode queryMode;
    private String databasePath;

    public DefaultQueryBuilder() {
        this.keyIds = ArrayUtils.EMPTY_STRING_ARRAY;
        this.propIds = ArrayUtils.EMPTY_STRING_ARRAY;
        this.queryMode = Query.DEFAULT_QUERY_MODE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(QueryMode queryMode) {
        this.queryMode = queryMode == null ? Query.DEFAULT_QUERY_MODE : queryMode;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    public final Filter getFilters() {
        return this.filters;
    }

    public final void setFilters(Filter filters) {
        this.filters = filters;
    }

    public final String[] getKeyIds() {
        return (String[])this.keyIds.clone();
    }

    public final void setKeyIds(String[] keyIds) {
        if (keyIds == null) {
            keyIds = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        this.keyIds = (String[])keyIds.clone();
    }

    public final String[] getPropositionIds() {
        return (String[])this.propIds.clone();
    }

    public final void setPropositionIds(String[] propIds) {
        if (propIds == null) {
            this.propIds = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            this.propIds = (String[])propIds.clone();
            ProtempaUtil.internAll(this.propIds);
        }
    }

    public final PropositionDefinition[] getPropositionDefinitions() {
        return (PropositionDefinition[])this.propDefs.clone();
    }

    public final void setPropositionDefinitions(PropositionDefinition[] propDefs) {
        if (propDefs == null) {
            propDefs = EMPTY_PROP_DEF_ARRAY;
        }
        this.propDefs = (PropositionDefinition[])propDefs.clone();
    }

    @Override
    public Query build(KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws QueryBuildException {
        if (validatePropositionIds) {
            HashSet<String> userSpecifiedPropIds = new HashSet<String>();
            for (PropositionDefinition propDef : this.propDefs) {
                userSpecifiedPropIds.add(propDef.getId());
            }
            ArrayList<Object> propIdsToTest = new ArrayList<Object>(this.propIds.length);
            for (PropositionDefinition propDef : this.propDefs) {
                for (String propId : propDef.getChildren()) {
                    if (userSpecifiedPropIds.contains(propId)) continue;
                    propIdsToTest.add(propId);
                }
            }
            for (String propId : this.propIds) {
                if (userSpecifiedPropIds.contains(propId)) continue;
                propIdsToTest.add(propId);
            }
            try {
                List<PropositionDefinition> pds = knowledgeSource.readPropositionDefinitions(propIdsToTest.toArray(new String[propIdsToTest.size()]));
                ArrayList<String> actualPropIds = new ArrayList<String>(pds.size());
                for (PropositionDefinition propDef : pds) {
                    actualPropIds.add(propDef.getId());
                }
                propIdsToTest.removeAll(actualPropIds);
                if (!propIdsToTest.isEmpty()) {
                    throw new QueryValidationException("Invalid proposition ids: " + propIdsToTest);
                }
            }
            catch (KnowledgeSourceReadException | QueryValidationException ex) {
                throw new QueryBuildException("Could not build query", ex);
            }
            if (Arrays.contains((Object[])QueryMode.reprocessModes(), (Object)((Object)this.queryMode)) && this.databasePath == null) {
                throw new QueryBuildException("Could not build query", new QueryValidationException("Database path must be specified in reprocess mode"));
            }
        }
        return new Query(this.name, this.username, this.keyIds, this.filters, this.propIds, this.propDefs, this.queryMode, this.databasePath);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static void setValidatePropositionIds(boolean validatePropositionIdsFlag) {
        validatePropositionIds = validatePropositionIdsFlag;
    }

    public static boolean isValidatePropositionIds() {
        return validatePropositionIds;
    }
}

