/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.valueset;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.NotRecordedSourceId;
import org.protempa.ProtempaUtil;
import org.protempa.SourceId;
import org.protempa.proposition.value.OrderedValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.valueset.ValueSetBuilder;
import org.protempa.valueset.ValueSetElement;
import org.protempa.valueset.ValueSetElementBuilder;

public final class ValueSet {
    private static final Logger LOGGER = Logger.getLogger(ValueSet.class.getName());
    private static final ValueSetElement[] EMPTY_VALUE_SET_ELT_ARRAY = new ValueSetElement[0];
    private final String id;
    private final String displayName;
    private final ValueSetElement[] valueSetElements;
    private final Map<Value, ValueSetElement> values;
    private final Set<Value> valuesKeySet;
    private final OrderedValue lowerBound;
    private final OrderedValue upperBound;
    private final SourceId sourceId;
    private final boolean ordered;

    public ValueSet(String id, String displayName, OrderedValue lowerBound, OrderedValue upperBound, SourceId sourceId) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = id.intern();
        this.displayName = displayName;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.valueSetElements = EMPTY_VALUE_SET_ELT_ARRAY;
        this.values = new HashMap<Value, ValueSetElement>();
        this.valuesKeySet = this.values.keySet();
        this.sourceId = sourceId == null ? NotRecordedSourceId.getInstance() : sourceId;
        this.ordered = true;
    }

    public ValueSet(String id, String displayName, ValueSetElement[] valueSetElements, SourceId sourceId) {
        this(id, displayName, valueSetElements, false, sourceId);
    }

    public ValueSet(String id, String displayName, ValueSetElement[] valueSetElements, boolean ordered, SourceId sourceId) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        ProtempaUtil.checkArray(valueSetElements, "valueSetElements");
        this.id = id.intern();
        this.displayName = displayName;
        this.valueSetElements = (ValueSetElement[])valueSetElements.clone();
        this.ordered = ordered;
        this.values = new HashMap<Value, ValueSetElement>();
        for (ValueSetElement vse : this.valueSetElements) {
            if (this.values.containsKey(vse.getValue())) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Ignoring duplicate value {0} for id {1}", new Object[]{vse.getValue().getFormatted(), id});
                continue;
            }
            this.values.put(vse.getValue(), vse);
        }
        this.valuesKeySet = this.values.keySet();
        this.lowerBound = null;
        this.upperBound = null;
        this.sourceId = sourceId == null ? NotRecordedSourceId.getInstance() : sourceId;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SourceId getSourceId() {
        return this.sourceId;
    }

    public ValueSetElement[] getValueSetElements() {
        return this.valueSetElements;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public OrderedValue getLowerBound() {
        return this.lowerBound;
    }

    public OrderedValue getUpperBound() {
        return this.upperBound;
    }

    public boolean isInValueSet(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        boolean result = true;
        if (!this.valuesKeySet.isEmpty()) {
            result = this.valuesKeySet.contains(value);
        } else if (this.lowerBound != null || this.upperBound != null) {
            if (this.lowerBound != null && !ValueComparator.GREATER_THAN_OR_EQUAL_TO.compare(value, this.lowerBound)) {
                result = false;
            }
            if (this.upperBound != null && !ValueComparator.LESS_THAN_OR_EQUAL_TO.compare(value, this.upperBound)) {
                result = false;
            }
        }
        return result;
    }

    public String displayName(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        ValueSetElement vse = this.values.get(value);
        if (vse != null) {
            return vse.getDisplayName();
        }
        return "";
    }

    public String abbrevDisplayName(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        ValueSetElement vse = this.values.get(value);
        if (vse != null) {
            return vse.getAbbrevDisplayName();
        }
        return "";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public ValueSetBuilder asBuilder() {
        ValueSetBuilder builder = new ValueSetBuilder();
        builder.setId(this.id);
        builder.setDisplayName(this.displayName);
        builder.setLowerBoundBuilder(this.lowerBound != null ? this.lowerBound.asBuilder() : null);
        builder.setSourceIdBuilder(this.sourceId.asBuilder());
        builder.setUpperBoundBuilder(this.upperBound != null ? this.upperBound.asBuilder() : null);
        ValueSetElementBuilder[] vseBuilders = new ValueSetElementBuilder[this.valueSetElements.length];
        for (int i = 0; i < this.valueSetElements.length; ++i) {
            vseBuilders[i] = this.valueSetElements[i].asBuilder();
        }
        builder.setValueSetElementBuilders(vseBuilders);
        return builder;
    }
}

