/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.ProtempaUtil;
import org.protempa.query.Query;

public class AbstractThread
extends Thread {
    private final Query query;
    private final MessageFormat logMessageFormat;
    private final Logger logger;

    AbstractThread(Query query, Logger logger, String name) {
        super(name);
        assert (query != null) : "query cannot be null";
        assert (logger != null) : "logger cannot be null";
        this.query = query;
        this.logMessageFormat = ProtempaUtil.getLogMessageFormat(this.query);
        this.logger = logger;
    }

    protected void log(Level level, String msg) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.logMessageFormat.format(new Object[]{msg}));
        }
    }

    protected void log(Level level, String msg, Throwable throwable) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.logMessageFormat.format(new Object[]{msg}), throwable);
        }
    }

    protected void log(Level level, String msg, Object param) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.logMessageFormat.format(new Object[]{msg}), param);
        }
    }

    protected boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    protected Query getQuery() {
        return this.query;
    }
}

