/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.AlgorithmSource;
import org.protempa.DoProcessThread;
import org.protempa.KnowledgeSource;
import org.protempa.PropositionDefinitionCache;
import org.protempa.QueueObject;
import org.protempa.StatefulExecutionStrategy;
import org.protempa.query.Query;

public class DoReprocessThread
extends DoProcessThread<StatefulExecutionStrategy> {
    private static final Logger LOGGER = Logger.getLogger(DoReprocessThread.class.getName());
    private final AlgorithmSource algorithmSource;

    DoReprocessThread(BlockingQueue<QueueObject> hqrQueue, QueueObject hqrPoisonPill, Query query, AlgorithmSource algorithmSource, KnowledgeSource knowledgeSource, PropositionDefinitionCache propositionDefinitionCache) {
        super(hqrQueue, hqrPoisonPill, query, null, knowledgeSource, propositionDefinitionCache, LOGGER);
        this.algorithmSource = algorithmSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessDataLoop() throws InterruptedException {
        int count = 0;
        StatefulExecutionStrategy executionStrategy = (StatefulExecutionStrategy)this.getExecutionStrategy();
        Iterator iterator = executionStrategy.getDataStore().keySet().iterator();
        while (!this.isInterrupted() && iterator.hasNext()) {
            String keyId = (String)iterator.next();
            try {
                this.doProcessData(keyId, null, -1, this.getQuery());
                ++count;
            }
            finally {
                this.closeWorkingMemory();
            }
        }
        this.log(Level.INFO, "Processed {0} keys", count);
    }

    @Override
    StatefulExecutionStrategy selectExecutionStrategy() {
        return new StatefulExecutionStrategy(this.algorithmSource, this.getQuery());
    }
}

