/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.spi.KnowledgeHelper;
import org.protempa.DerivationsBuilder;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.SourceSystem;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.UniqueIdFactory;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;

class PropositionCopier
extends AbstractPropositionVisitor
implements Serializable {
    private static final long serialVersionUID = 1236050515546951710L;
    private static final Logger LOGGER = Logger.getLogger(PropositionCopier.class.getName());
    private final String propId;
    private final DerivationsBuilder derivationsBuilder;
    private KnowledgeHelper kh;
    private UniqueIdFactory uniqueIdProvider;

    PropositionCopier(String propId, DerivationsBuilder derivationsBuilder) {
        assert (propId != null) : "propId cannot be null";
        assert (derivationsBuilder != null) : "derivationsBuilder cannot be null";
        this.derivationsBuilder = derivationsBuilder;
        this.propId = propId;
    }

    void grab(KnowledgeHelper kh) {
        assert (kh != null) : "kh cannot be null";
        assert (this.kh == null) : "The previous user of this copier forgot to call release!";
        if (this.kh != null) {
            LOGGER.log(Level.WARNING, "The previous user of this copier forgot to call release. This causes a memory leak!");
        }
        this.kh = kh;
        this.uniqueIdProvider = new ProviderBasedUniqueIdFactory(new JBossRulesDerivedLocalUniqueIdValuesProvider(this.kh.getWorkingMemory(), this.propId));
    }

    void release() {
        this.kh = null;
    }

    @Override
    public void visit(AbstractParameter abstractParameter) {
        assert (this.kh != null) : "kh wasn't set";
        AbstractParameter param = new AbstractParameter(this.propId, this.uniqueIdProvider.getInstance());
        param.setSourceSystem(SourceSystem.DERIVED);
        param.setInterval(abstractParameter.getInterval());
        param.setValue(abstractParameter.getValue());
        param.setCreateDate(new Date());
        this.kh.insertLogical((Object)param);
        this.derivationsBuilder.propositionAsserted(abstractParameter, param);
        LOGGER.log(Level.FINER, "Asserted derived proposition {0}", param);
    }

    @Override
    public void visit(Event event) {
        assert (this.kh != null) : "kh wasn't set";
        Event e = new Event(this.propId, this.uniqueIdProvider.getInstance());
        e.setInterval(event.getInterval());
        e.setSourceSystem(SourceSystem.DERIVED);
        e.setCreateDate(new Date());
        this.kh.insertLogical((Object)e);
        this.derivationsBuilder.propositionAsserted(event, e);
        LOGGER.log(Level.FINER, "Asserted derived proposition {0}", e);
    }

    @Override
    public void visit(PrimitiveParameter primitiveParameter) {
        assert (this.kh != null) : "kh wasn't set";
        PrimitiveParameter param = new PrimitiveParameter(this.propId, this.uniqueIdProvider.getInstance());
        param.setPosition(primitiveParameter.getPosition());
        param.setGranularity(primitiveParameter.getGranularity());
        param.setValue(primitiveParameter.getValue());
        param.setSourceSystem(SourceSystem.DERIVED);
        param.setCreateDate(new Date());
        this.kh.insertLogical((Object)param);
        this.derivationsBuilder.propositionAsserted(primitiveParameter, param);
        LOGGER.log(Level.FINER, "Asserted derived proposition {0}", param);
    }

    @Override
    public void visit(Constant constant) {
        assert (this.kh != null) : "kh wasn't set";
        Constant newConstant = new Constant(this.propId, this.uniqueIdProvider.getInstance());
        newConstant.setSourceSystem(SourceSystem.DERIVED);
        newConstant.setCreateDate(new Date());
        this.kh.insertLogical((Object)newConstant);
        this.derivationsBuilder.propositionAsserted(constant, newConstant);
        LOGGER.log(Level.FINER, "Asserted derived proposition {0}", newConstant);
    }

    @Override
    public void visit(Context context) {
        assert (this.kh != null) : "kh wasn't set";
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

