/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.event.DefaultWorkingMemoryEventListener;
import org.drools.event.ObjectRetractedEvent;
import org.protempa.SetDeleteDatePropositionVisitor;
import org.protempa.proposition.Proposition;

final class DeletedWorkingMemoryEventListener
extends DefaultWorkingMemoryEventListener {
    private static final Logger LOGGER = Logger.getLogger(DeletedWorkingMemoryEventListener.class.getName());
    private final List<Proposition> propsToDelete = new ArrayList<Proposition>();
    private final SetDeleteDatePropositionVisitor setDeleteDatePropVisitor = new SetDeleteDatePropositionVisitor();

    public void objectRetracted(ObjectRetractedEvent ore) {
        String name = ore.getPropagationContext().getRuleOrigin().getName();
        if (name.equals("DELETE_PROPOSITION")) {
            Proposition prop = (Proposition)ore.getOldObject();
            LOGGER.log(Level.FINEST, "Deleted proposition {0}", prop);
            prop.accept(this.setDeleteDatePropVisitor);
            this.propsToDelete.add(this.setDeleteDatePropVisitor.getDeleted());
        }
    }

    List<Proposition> getPropsToDelete() {
        return new ArrayList<Proposition>(this.propsToDelete);
    }

    void clear() {
        this.propsToDelete.clear();
    }
}

