/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import org.arp.javautil.string.StringUtil;
import org.protempa.dest.table.AbstractTabularWriter;
import org.protempa.dest.table.QuoteModel;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

public class FileTabularWriter
extends AbstractTabularWriter {
    private final BufferedWriter writer;
    private int colIndex;
    private final char delimiter;
    private final QuoteModel quoteModel;
    private final Map<String, String> replacement;

    public FileTabularWriter(BufferedWriter inWriter, char inDelimiter) {
        this(inWriter, inDelimiter, null);
    }

    public FileTabularWriter(BufferedWriter inWriter, char inDelimiter, QuoteModel inQuoteModel) {
        this(inWriter, inDelimiter, inQuoteModel, null);
    }

    public FileTabularWriter(BufferedWriter inWriter, char inDelimiter, QuoteModel inQuoteModel, String nullValue) {
        this.writer = inWriter;
        this.delimiter = inDelimiter;
        this.quoteModel = inQuoteModel == null ? QuoteModel.WHEN_QUOTE_EMBEDDED : inQuoteModel;
        this.replacement = new HashMap<String, String>();
        if (nullValue == null) {
            this.replacement.put(null, "NULL");
        } else {
            this.replacement.put(null, nullValue);
        }
    }

    @Override
    public final void writeNominal(NominalValue inValue, Format inFormat) throws TabularWriterException {
        this.writeString(inValue != null ? inValue.format(inFormat) : null);
    }

    @Override
    public final void writeNumber(NumberValue inValue, Format inFormat) throws TabularWriterException {
        this.writeString(inValue != null ? inValue.format(inFormat) : null);
    }

    @Override
    public final void writeInequality(InequalityNumberValue inValue, Format inFormat) throws TabularWriterException {
        String comparatorString = inValue != null ? inValue.getInequality().getComparatorString() : null;
        this.writeString(inFormat != null ? inFormat.format(comparatorString) : comparatorString);
    }

    @Override
    public final void writeNumber(InequalityNumberValue inValue, Format inFormat) throws TabularWriterException {
        this.writeString(inValue != null ? inValue.getNumberValue().format(inFormat) : null);
    }

    @Override
    public final void writeInequalityNumber(InequalityNumberValue inValue, Format inFormat) throws TabularWriterException {
        this.writeString(inValue != null ? inValue.format(inFormat) : null);
    }

    @Override
    public final void writeDate(DateValue inValue, Format inFormat) throws TabularWriterException {
        this.writeString(inValue != null ? inValue.format(inFormat) : null);
    }

    @Override
    public final void writeBoolean(BooleanValue inValue, Format inFormat) throws TabularWriterException {
        this.writeString(inValue != null ? inValue.format(inFormat) : null);
    }

    @Override
    public final void writeId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getId();
        this.writeString(value);
    }

    @Override
    public final void writeUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getStringRepresentation();
        this.writeString(value);
    }

    @Override
    public final void writeLocalUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getLocalUniqueId().getId();
        this.writeString(value);
    }

    @Override
    public final void writeNumericalId(Proposition inProposition) throws TabularWriterException {
        String value = String.valueOf(inProposition.getUniqueId().getLocalUniqueId().getNumericalId());
        this.writeString(value);
    }

    @Override
    public final void writeStart(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat == null ? inProposition.getStartFormattedShort() : inProposition.formatStart(inFormat);
        this.writeString(value);
    }

    @Override
    public final void writeFinish(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat == null ? inProposition.getFinishFormattedShort() : inProposition.formatFinish(inFormat);
        this.writeString(value);
    }

    @Override
    public final void writeLength(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat == null ? inProposition.getLengthFormattedShort() : inProposition.formatLength(inFormat);
        this.writeString(value);
    }

    @Override
    public final void writeParameterValue(Parameter inProposition, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getValue();
        this.writeValue(value, inFormat);
    }

    @Override
    public final void writePropertyValue(Proposition inProposition, String inPropertyName, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getProperty(inPropertyName);
        this.writeValue(value, inFormat);
    }

    @Override
    public final void writeNull() throws TabularWriterException {
        this.writeString(null);
    }

    @Override
    public final void newRow() throws TabularWriterException {
        try {
            this.writer.newLine();
            this.colIndex = 0;
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public final void close() throws TabularWriterException {
        try {
            this.writer.close();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    private void writeDelimiter() throws IOException {
        if (this.colIndex > 0) {
            this.writer.write(this.delimiter);
        }
    }

    private void escapeAndWriteDelimitedColumn(String inValue) throws IOException {
        if (this.quoteModel == QuoteModel.ALWAYS) {
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue, (char)this.delimiter, (boolean)true, this.replacement, (Writer)this.writer);
        } else {
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue, (char)this.delimiter, this.replacement, (Writer)this.writer);
        }
    }

    private void incr() {
        ++this.colIndex;
    }

    private void writeString(String inValue) throws TabularWriterException {
        try {
            this.writeDelimiter();
            this.escapeAndWriteDelimitedColumn(inValue);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }
}

