/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.ProtempaUtil;
import org.protempa.query.Query;

class AbstractThread
extends Thread {
    private final Query query;
    private final MessageFormat logMessageFormat;
    private final Logger logger;

    AbstractThread(Query query, Logger logger, String name) {
        super(name);
        assert (query != null) : "query cannot be null";
        assert (logger != null) : "logger cannot be null";
        this.query = query;
        this.logMessageFormat = ProtempaUtil.getLogMessageFormat(this.query);
        this.logger = logger;
    }

    final void log(Level level, String msg) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.logMessageFormat.format(new Object[]{msg}));
        }
    }

    final void log(Level level, String msg, Throwable throwable) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.logMessageFormat.format(new Object[]{msg}), throwable);
        }
    }

    final void log(Level level, String msg, Object param) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, this.logMessageFormat.format(new Object[]{msg}), param);
        }
    }

    final boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    final Query getQuery() {
        return this.query;
    }
}

