/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collection;
import java.util.Map;
import org.drools.conflict.AbstractConflictResolver;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.protempa.CycleDetectedException;
import org.protempa.PropositionDefinition;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.TopologicalSortComparator;

final class PROTEMPAConflictResolver
extends AbstractConflictResolver {
    private static final long serialVersionUID = -2690384525731832692L;
    private final TopologicalSortComparator topSortComp;
    private final Map<Rule, ? extends TemporalPropositionDefinition> ruleToTPD;

    PROTEMPAConflictResolver(Collection<? extends PropositionDefinition> allNarrowerDescendants, Map<Rule, ? extends TemporalPropositionDefinition> ruleToTPD) throws CycleDetectedException {
        assert (allNarrowerDescendants != null) : "allNarrowerDescendants cannot be null";
        this.topSortComp = new TopologicalSortComparator(allNarrowerDescendants, ruleToTPD.values());
        this.ruleToTPD = ruleToTPD;
    }

    public int compare(Activation a1, Activation a2) {
        Rule rule2;
        long r2;
        long p2;
        int s2;
        int s1 = a1.getSalience();
        if (s1 > (s2 = a2.getSalience())) {
            return -1;
        }
        if (s1 < s2) {
            return 1;
        }
        long p1 = a1.getPropagationContext().getPropagationNumber();
        if (p1 != (p2 = a2.getPropagationContext().getPropagationNumber())) {
            return (int)(p2 - p1);
        }
        long r1 = a1.getTuple().getRecency();
        if (r1 != (r2 = a2.getTuple().getRecency())) {
            return (int)(r2 - r1);
        }
        Rule rule1 = a1.getRule();
        if (rule1 != (rule2 = a2.getRule())) {
            TemporalPropositionDefinition def1 = this.ruleToTPD.get(rule1);
            TemporalPropositionDefinition def2 = this.ruleToTPD.get(rule2);
            if (def1 != null && def2 != null) {
                return this.topSortComp.compare(def1, def2);
            }
        }
        long l1 = rule1.getLoadOrder();
        long l2 = rule2.getLoadOrder();
        return (int)(l2 - l1);
    }
}

