/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashMap;
import java.util.Map;
import org.protempa.AbstractPropositionDefinitionCheckedVisitor;
import org.protempa.Algorithm;
import org.protempa.AlgorithmSource;
import org.protempa.AlgorithmSourceReadException;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.ConstantDefinition;
import org.protempa.ContextDefinition;
import org.protempa.EventDefinition;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.NoSuchAlgorithmException;
import org.protempa.PrimitiveParameterDefinition;
import org.protempa.SequentialTemporalPatternDefinition;
import org.protempa.SliceDefinition;

class ValidateAlgorithmCheckedVisitor
extends AbstractPropositionDefinitionCheckedVisitor {
    private final Map<LowLevelAbstractionDefinition, Algorithm> algorithms;
    private final AlgorithmSource algorithmSource;

    ValidateAlgorithmCheckedVisitor(AlgorithmSource algorithmSource) {
        assert (algorithmSource != null) : "algorithmSource cannot be null";
        this.algorithms = new HashMap<LowLevelAbstractionDefinition, Algorithm>();
        this.algorithmSource = algorithmSource;
    }

    Map<LowLevelAbstractionDefinition, Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    @Override
    public void visit(LowLevelAbstractionDefinition lowLevelAbstractionDefinition) throws NoSuchAlgorithmException, AlgorithmSourceReadException {
        String algorithmId = lowLevelAbstractionDefinition.getAlgorithmId();
        Algorithm algorithm = this.algorithmSource.readAlgorithm(algorithmId);
        if (algorithm == null && algorithmId != null) {
            throw new NoSuchAlgorithmException("Low level abstraction definition " + lowLevelAbstractionDefinition.getId() + " wants the algorithm " + algorithmId + ", but no such algorithm is available.");
        }
        this.algorithms.put(lowLevelAbstractionDefinition, algorithm);
    }

    @Override
    public void visit(CompoundLowLevelAbstractionDefinition extendedLowLevelAbstractionDefinition) {
    }

    @Override
    public void visit(EventDefinition eventDefinition) {
    }

    @Override
    public void visit(HighLevelAbstractionDefinition highLevelAbstractionDefinition) {
    }

    @Override
    public void visit(PrimitiveParameterDefinition primitiveParameterDefinition) {
    }

    @Override
    public void visit(SliceDefinition sliceAbstractionDefinition) {
    }

    @Override
    public void visit(SequentialTemporalPatternDefinition pairAbstractionDefinition) {
    }

    @Override
    public void visit(ConstantDefinition def) {
    }

    @Override
    public void visit(ContextDefinition def) {
    }
}

