/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.protempa.AbstractSource;
import org.protempa.DataSource;
import org.protempa.DataSourceReadException;
import org.protempa.DataSourceUpdatedEvent;
import org.protempa.DataSourceWriteException;
import org.protempa.DataStreamingEventIterator;
import org.protempa.KeySetSpec;
import org.protempa.MultiplexingDataStreamingEventIterator;
import org.protempa.PropositionDataStreamerProcessor;
import org.protempa.SourceCloseException;
import org.protempa.backend.Backend;
import org.protempa.backend.DataSourceBackendUpdatedEvent;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.key.KeySetQueryResultsHandler;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.value.GranularityFactory;
import org.protempa.proposition.value.UnitFactory;

public final class DataSourceImpl
extends AbstractSource<DataSourceUpdatedEvent, DataSourceBackend, DataSourceUpdatedEvent, DataSourceBackendUpdatedEvent>
implements DataSource {
    public DataSourceImpl(DataSourceBackend[] backends) {
        super((Backend[])(backends != null ? backends : new DataSourceBackend[]{}));
    }

    @Override
    public String getKeyType() throws DataSourceReadException {
        this.initializeIfNeeded();
        String result = null;
        DataSourceBackend b = null;
        DataSourceBackend[] dataSourceBackendArray = (DataSourceBackend[])this.getBackends();
        int n = dataSourceBackendArray.length;
        int n2 = 0;
        if (n2 < n) {
            DataSourceBackend backend = dataSourceBackendArray[n2];
            result = backend.getKeyType();
            b = backend;
        }
        assert (result != null) : "no key type found in " + b.getClass() + "!";
        return result;
    }

    @Override
    public String getKeyTypeDisplayName() throws DataSourceReadException {
        this.initializeIfNeeded();
        String result = null;
        DataSourceBackend b = null;
        DataSourceBackend[] dataSourceBackendArray = (DataSourceBackend[])this.getBackends();
        int n = dataSourceBackendArray.length;
        int n2 = 0;
        if (n2 < n) {
            DataSourceBackend backend = dataSourceBackendArray[n2];
            result = backend.getKeyTypeDisplayName();
            b = backend;
        }
        assert (result != null) : "no key type display name found in " + b.getClass() + "!";
        return result;
    }

    @Override
    public String getKeyTypePluralDisplayName() throws DataSourceReadException {
        this.initializeIfNeeded();
        String result = null;
        DataSourceBackend b = null;
        DataSourceBackend[] dataSourceBackendArray = (DataSourceBackend[])this.getBackends();
        int n = dataSourceBackendArray.length;
        int n2 = 0;
        if (n2 < n) {
            DataSourceBackend backend = dataSourceBackendArray[n2];
            result = backend.getKeyTypePluralDisplayName();
            b = backend;
        }
        assert (result != null) : "no key type plural display name found in " + b.getClass() + "!";
        return result;
    }

    @Override
    public KeySetSpec[] getSelectedKeySetSpecs() throws DataSourceReadException {
        this.initializeIfNeeded();
        ArrayList result = new ArrayList();
        for (DataSourceBackend backend : (DataSourceBackend[])this.getBackends()) {
            Arrays.addAll(result, (Object[][])new KeySetSpec[][]{backend.getSelectedKeySetSpecs()});
        }
        return result.toArray(new KeySetSpec[result.size()]);
    }

    @Override
    public GranularityFactory getGranularityFactory() throws DataSourceReadException {
        this.initializeIfNeeded();
        GranularityFactory result = null;
        DataSourceBackend b = null;
        DataSourceBackend[] dataSourceBackendArray = (DataSourceBackend[])this.getBackends();
        int n = dataSourceBackendArray.length;
        int n2 = 0;
        if (n2 < n) {
            DataSourceBackend backend = dataSourceBackendArray[n2];
            result = backend.getGranularityFactory();
            b = backend;
        }
        assert (result != null) : "no granularity factory returned from " + b.getClass() + "!";
        return result;
    }

    @Override
    public UnitFactory getUnitFactory() throws DataSourceReadException {
        this.initializeIfNeeded();
        UnitFactory result = null;
        DataSourceBackend b = null;
        DataSourceBackend[] dataSourceBackendArray = (DataSourceBackend[])this.getBackends();
        int n = dataSourceBackendArray.length;
        int n2 = 0;
        if (n2 < n) {
            DataSourceBackend backend = dataSourceBackendArray[n2];
            result = backend.getUnitFactory();
            b = backend;
        }
        assert (result != null) : "no unit factory returned from " + b.getClass() + "!";
        return result;
    }

    @Override
    public DataStreamingEventIterator<Proposition> readPropositions(Set<String> keyIds, Set<String> propIds, Filter filters, QueryResultsHandler queryResultsHandler) throws DataSourceReadException {
        Set<String> notNullKeyIds = DataSourceImpl.handleKeyIdSetArgument(keyIds);
        Set<String> notNullPropIds = DataSourceImpl.handlePropIdSetArgument(propIds);
        this.initializeIfNeeded();
        DataSourceBackend[] backends = (DataSourceBackend[])this.getBackends();
        ArrayList<DataStreamingEventIterator<Proposition>> itrs = new ArrayList<DataStreamingEventIterator<Proposition>>(backends.length);
        for (DataSourceBackend backend : backends) {
            try {
                itrs.add(backend.readPropositions(notNullKeyIds, notNullPropIds, filters, queryResultsHandler));
            }
            catch (Error | RuntimeException ex) {
                throw new DataSourceReadException("Unexpected error accessing " + backend.getDisplayName(), ex);
            }
        }
        return new MultiplexingDataStreamingEventIterator(itrs, new PropositionDataStreamerProcessor());
    }

    @Override
    public void deleteAllKeys() throws DataSourceWriteException {
        for (DataSourceBackend backend : (DataSourceBackend[])this.getBackends()) {
            try {
                backend.deleteAllKeys();
            }
            catch (Error | RuntimeException ex) {
                throw new DataSourceWriteException("Unexpected error accessing " + backend.getDisplayName(), ex);
            }
        }
    }

    @Override
    public void writeKeys(Set<String> keyIds) throws DataSourceWriteException {
        for (DataSourceBackend backend : (DataSourceBackend[])this.getBackends()) {
            try {
                backend.writeKeys(keyIds);
            }
            catch (Error | RuntimeException ex) {
                throw new DataSourceWriteException("Unexpected error accessing " + backend.getDisplayName(), ex);
            }
        }
    }

    @Override
    public void writeKeysFromKeySet(KeySetQueryResultsHandler queryResultsHandler) throws DataSourceWriteException {
        for (DataSourceBackend backend : (DataSourceBackend[])this.getBackends()) {
            try {
                backend.writeKeysFromKeySet(queryResultsHandler);
            }
            catch (Error | RuntimeException ex) {
                throw new DataSourceWriteException("Unexpected error accessing " + backend.getDisplayName(), ex);
            }
        }
    }

    @Override
    public void backendUpdated(DataSourceBackendUpdatedEvent evt) {
        this.clear();
        this.fireDataSourceUpdated();
    }

    @Override
    public void close() throws SourceCloseException {
        this.clear();
        super.close();
    }

    @Override
    public void clear() {
    }

    private void initializeIfNeeded() throws DataSourceReadException {
        if (this.isClosed()) {
            throw new DataSourceReadException("Data source already closed!");
        }
    }

    private void fireDataSourceUpdated() {
        this.fireSourceUpdated(new DataSourceUpdatedEvent(this));
    }

    private static Set<String> handleKeyIdSetArgument(Set<String> keyIds) {
        if (keyIds == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(keyIds);
    }

    private static Set<String> handlePropIdSetArgument(Set<String> propIds) {
        if (propIds != null) {
            return new HashSet<String>(propIds);
        }
        throw new IllegalArgumentException("propIds cannot be null");
    }
}

