/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.AbstractThread;
import org.protempa.AbstractionDefinition;
import org.protempa.AlgorithmSource;
import org.protempa.ContextDefinition;
import org.protempa.DerivationsBuilder;
import org.protempa.ExecutionStrategy;
import org.protempa.ExecutionStrategyExecutionException;
import org.protempa.ExecutionStrategyInitializationException;
import org.protempa.ExecutionStrategyShutdownException;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.QueryException;
import org.protempa.QueueObject;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.query.Query;

abstract class DoProcessThread<E extends ExecutionStrategy>
extends AbstractThread {
    private final BlockingQueue<QueueObject> hqrQueue;
    private final QueueObject hqrPoisonPill;
    private final Thread producer;
    private E executionStrategy;
    private final List<QueryException> exceptions;
    private final PropositionDefinitionCache propositionDefinitionCache;
    private final KnowledgeSource knowledgeSource;
    private DerivationsBuilder derivationsBuilder;
    private final AlgorithmSource algorithmSource;

    DoProcessThread(BlockingQueue<QueueObject> hqrQueue, QueueObject hqrPoisonPill, Query query, Thread producer, KnowledgeSource knowledgeSource, PropositionDefinitionCache propositionDefinitionCache, AlgorithmSource algorithmSource, Logger logger) throws QueryException {
        super(query, logger, "protempa.executor.DoProcessThread");
        this.hqrQueue = hqrQueue;
        this.producer = producer;
        this.hqrPoisonPill = hqrPoisonPill;
        this.exceptions = new ArrayList<QueryException>();
        this.knowledgeSource = knowledgeSource;
        this.propositionDefinitionCache = propositionDefinitionCache;
        assert (algorithmSource != null) : "algorithmSource cannot be null";
        this.algorithmSource = algorithmSource;
        try {
            this.initialize();
        }
        catch (ExecutionStrategyInitializationException | KnowledgeSourceReadException ex) {
            throw new QueryException(query.getName(), ex);
        }
    }

    @Override
    public final void run() {
        this.log(Level.FINER, "Start do process thread");
        try {
            this.doProcessDataLoop();
            this.swallowHQRPoisonPill();
        }
        catch (InterruptedException ex) {
            this.handleInterrupted(ex);
        }
        catch (Error | RuntimeException t) {
            this.log(Level.SEVERE, "Do process thread threw runtime error", t);
            this.handleException();
            throw t;
        }
        finally {
            this.shutdownExecutionStrategy();
        }
        this.log(Level.FINER, "End do process thread");
    }

    final AlgorithmSource getAlgorithmSource() {
        return this.algorithmSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doProcessData(String keyId, Iterator<Proposition> dataItr, int sizeHint, Query query) throws InterruptedException {
        try {
            Iterator<Proposition> resultsItr = this.executionStrategy != null ? this.executionStrategy.execute(keyId, dataItr) : dataItr;
            Map<Proposition, Set<Proposition>> forwardDerivations = this.derivationsBuilder.getForwardDerivations();
            Map<Proposition, Set<Proposition>> backwardDerivations = this.derivationsBuilder.getBackwardDerivations();
            HashMap<UniqueId, Proposition> refs = new HashMap<UniqueId, Proposition>();
            List<Proposition> filteredPropositions = this.extractRequestedPropositions(resultsItr, refs, sizeHint);
            if (this.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "Proposition ids: {0}", String.join((CharSequence)", ", query.getPropositionIds()));
                this.log(Level.FINEST, "Filtered propositions: {0}", filteredPropositions);
                this.log(Level.FINEST, "Forward derivations: {0}", forwardDerivations);
                this.log(Level.FINEST, "Backward derivations: {0}", backwardDerivations);
                this.log(Level.FINEST, "References: {0}", refs);
            }
            this.hqrQueue.put(new QueueObject(keyId, filteredPropositions, forwardDerivations, backwardDerivations, refs));
            this.log(Level.FINER, "Results put on query result handler queue");
        }
        catch (ExecutionStrategyExecutionException ex) {
            this.exceptions.add(new QueryException(query.getName(), ex));
        }
        finally {
            this.derivationsBuilder.reset();
        }
    }

    abstract void doProcessDataLoop() throws InterruptedException;

    abstract E selectExecutionStrategy();

    final E getExecutionStrategy() {
        return this.executionStrategy;
    }

    final void closeWorkingMemory() {
        if (this.executionStrategy != null) {
            this.executionStrategy.closeCurrentWorkingMemory();
        }
    }

    final List<QueryException> getExceptions() {
        return this.exceptions;
    }

    private List<Proposition> extractRequestedPropositions(Iterator<Proposition> propositions, Map<UniqueId, Proposition> refs, int sizeHint) {
        ArrayList<Proposition> result = new ArrayList<Proposition>(sizeHint > -1 ? sizeHint : 200);
        if (propositions != null) {
            while (!this.isInterrupted() && propositions.hasNext()) {
                Proposition prop = propositions.next();
                refs.put(prop.getUniqueId(), prop);
                result.add(prop);
            }
        }
        return result;
    }

    private void swallowHQRPoisonPill() throws InterruptedException {
        this.hqrQueue.put(this.hqrPoisonPill);
    }

    private void handleInterrupted(InterruptedException ex) {
        this.log(Level.FINER, "Do process thread interrupted", ex);
        if (this.producer != null) {
            this.producer.interrupt();
        }
    }

    private void shutdownExecutionStrategy() {
        if (this.executionStrategy != null) {
            try {
                this.executionStrategy.shutdown();
            }
            catch (ExecutionStrategyShutdownException ex) {
                this.exceptions.add(new QueryException(this.getQuery().getName(), ex));
            }
        }
    }

    private void handleException() {
        if (this.producer != null) {
            this.producer.interrupt();
        }
        try {
            this.swallowHQRPoisonPill();
        }
        catch (InterruptedException ignore) {
            this.log(Level.SEVERE, "Failed to stop the query results handler queue; the query may be hung", ignore);
        }
    }

    private void initialize() throws KnowledgeSourceReadException, ExecutionStrategyInitializationException {
        Query query = this.getQuery();
        if (this.hasSomethingToAbstract(query) || query.getDatabasePath() != null) {
            this.executionStrategy = this.selectExecutionStrategy();
            this.executionStrategy.initialize(this.propositionDefinitionCache);
            this.derivationsBuilder = this.executionStrategy.getDerivationsBuilder();
        } else {
            this.derivationsBuilder = new DerivationsBuilder();
        }
    }

    private boolean hasSomethingToAbstract(Query query) throws KnowledgeSourceReadException {
        if (!this.knowledgeSource.readAbstractionDefinitions(query.getPropositionIds()).isEmpty() || !this.knowledgeSource.readContextDefinitions(query.getPropositionIds()).isEmpty()) {
            return true;
        }
        for (PropositionDefinition propDef : query.getPropositionDefinitions()) {
            if (!(propDef instanceof AbstractionDefinition) && !(propDef instanceof ContextDefinition)) continue;
            return true;
        }
        return false;
    }
}

