/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.AbstractAbstractionDefinition;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.PropositionDefinitionCheckedVisitor;
import org.protempa.PropositionDefinitionVisitor;
import org.protempa.ProtempaException;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPatternOffset;
import org.protempa.proposition.interval.Relation;

public final class HighLevelAbstractionDefinition
extends AbstractAbstractionDefinition {
    private static final long serialVersionUID = -2434163106247371362L;
    private TemporalPatternOffset temporalOffset;
    private boolean concatenable;
    private transient Set<ExtendedPropositionDefinition> defs;
    private transient Set<String> defsAsList;
    private transient boolean defsAsListOutdated;
    private transient Map<List<TemporalExtendedPropositionDefinition>, Relation> defPairsMap;
    private boolean solid;

    public HighLevelAbstractionDefinition(String id) {
        super(id);
        this.initInstance();
        this.concatenable = true;
        this.solid = true;
    }

    private void initInstance() {
        this.defs = new HashSet<ExtendedPropositionDefinition>();
        this.defsAsList = new HashSet<String>();
        this.defsAsListOutdated = true;
        this.defPairsMap = new HashMap<List<TemporalExtendedPropositionDefinition>, Relation>();
    }

    @Override
    public void accept(PropositionDefinitionVisitor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null.");
        }
        processor.visit(this);
    }

    @Override
    public void acceptChecked(PropositionDefinitionCheckedVisitor processor) throws ProtempaException {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null.");
        }
        processor.visit(this);
    }

    public boolean setRelation(TemporalExtendedPropositionDefinition lhsDef, TemporalExtendedPropositionDefinition rhsDef, Relation relation) {
        if (lhsDef == null || rhsDef == null || relation == null) {
            return false;
        }
        if (!this.defs.contains(lhsDef) || !this.defs.contains(rhsDef)) {
            return false;
        }
        List<TemporalExtendedPropositionDefinition> rulePair = Arrays.asList(lhsDef, rhsDef);
        this.defPairsMap.put(rulePair, relation);
        return true;
    }

    public boolean removeRelation(TemporalExtendedPropositionDefinition lhsRule, TemporalExtendedPropositionDefinition rhsRule) {
        List<TemporalExtendedPropositionDefinition> key = Arrays.asList(lhsRule, rhsRule);
        return this.defPairsMap.remove(key) != null;
    }

    public Set<ExtendedPropositionDefinition> getExtendedPropositionDefinitions() {
        return Collections.unmodifiableSet(this.defs);
    }

    @Override
    public Set<String> getAbstractedFrom() {
        if (this.defsAsListOutdated) {
            this.defsAsList.clear();
            for (ExtendedPropositionDefinition epd : this.defs) {
                this.defsAsList.add(epd.getPropositionId());
            }
            this.defsAsListOutdated = false;
        }
        return Collections.unmodifiableSet(this.defsAsList);
    }

    public boolean add(ExtendedPropositionDefinition def) {
        if (def != null && this.defs.add(def)) {
            this.defsAsListOutdated = true;
            this.recalculateChildren();
            return true;
        }
        return false;
    }

    public Relation getRelation(TemporalExtendedPropositionDefinition lhsDef, TemporalExtendedPropositionDefinition rhsDef) {
        return this.defPairsMap.get(Arrays.asList(lhsDef, rhsDef));
    }

    public Relation getRelation(List<TemporalExtendedPropositionDefinition> epdPair) {
        return this.defPairsMap.get(epdPair);
    }

    public boolean removeAllRelations(TemporalExtendedPropositionDefinition def) {
        Iterator<List<TemporalExtendedPropositionDefinition>> itr = this.defPairsMap.keySet().iterator();
        while (itr.hasNext()) {
            List<TemporalExtendedPropositionDefinition> pair = itr.next();
            if (pair.get(0) != def && pair.get(1) != def) continue;
            itr.remove();
        }
        return true;
    }

    public boolean remove(ExtendedPropositionDefinition def) {
        if (def instanceof TemporalExtendedPropositionDefinition) {
            return this.removeAllRelations((TemporalExtendedPropositionDefinition)def);
        }
        boolean result = this.defs.remove(def);
        if (result) {
            this.recalculateChildren();
            this.defsAsListOutdated = true;
        }
        return result;
    }

    public Set<List<TemporalExtendedPropositionDefinition>> getTemporalExtendedPropositionDefinitionPairs() {
        return Collections.unmodifiableSet(this.defPairsMap.keySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.defPairsMap);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initInstance();
        Map rulePairsMap = (Map)s.readObject();
        for (List list : rulePairsMap.keySet()) {
            this.add((ExtendedPropositionDefinition)list.get(0));
            this.add((ExtendedPropositionDefinition)list.get(1));
        }
        for (Map.Entry entry : rulePairsMap.entrySet()) {
            List rulep = (List)entry.getKey();
            this.setRelation((TemporalExtendedPropositionDefinition)rulep.get(0), (TemporalExtendedPropositionDefinition)rulep.get(1), (Relation)entry.getValue());
        }
    }

    public TemporalPatternOffset getTemporalOffset() {
        return this.temporalOffset;
    }

    public void setTemporalOffset(TemporalPatternOffset temporalOffset) {
        this.temporalOffset = temporalOffset;
    }

    @Override
    public void reset() {
        super.reset();
        this.setTemporalOffset(null);
        this.initInstance();
    }

    public void setConcatenable(boolean concatenable) {
        this.concatenable = concatenable;
    }

    public void setSolid(boolean solid) {
        this.solid = solid;
    }

    @Override
    public boolean isConcatenable() {
        return this.concatenable;
    }

    @Override
    public boolean isSolid() {
        return this.solid;
    }

    @Override
    protected void recalculateChildren() {
        String[] inverseIsA;
        Set<String> abstractedFrom = this.getAbstractedFrom();
        HashSet<String> directChildrenLocal = new HashSet<String>(abstractedFrom);
        for (String propId : inverseIsA = this.getInverseIsA()) {
            directChildrenLocal.add(propId);
        }
        this.children = directChildrenLocal.toArray(new String[directChildrenLocal.size()]);
    }

    @Override
    public String toString() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this);
        builder.setAppendTransients(true);
        return builder.toString();
    }
}

