/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.deid;

import java.util.List;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.ProtempaEventListener;
import org.protempa.dest.AbstractDestination;
import org.protempa.dest.Destination;
import org.protempa.dest.GetSupportedPropositionIdsException;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.Statistics;
import org.protempa.dest.StatisticsException;
import org.protempa.dest.deid.DeidConfig;
import org.protempa.dest.deid.DeidentifiedQueryResultsHandler;
import org.protempa.dest.deid.EncryptionInitException;
import org.protempa.query.Query;

public final class DeidentifiedDestination
extends AbstractDestination {
    private final Destination destination;
    private final DeidConfig deidConfig;
    private final String id;

    public DeidentifiedDestination(Destination destination, DeidConfig deidConfig) {
        if (destination == null) {
            throw new IllegalArgumentException("destination cannot be null");
        }
        if (deidConfig == null) {
            throw new IllegalArgumentException("deidConfig cannot be null");
        }
        this.destination = destination;
        this.deidConfig = deidConfig;
        this.id = this.destination.getId() + " with deidentification";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public QueryResultsHandler getQueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource, List<? extends ProtempaEventListener> eventListeners) throws QueryResultsHandlerInitException {
        try {
            return new DeidentifiedQueryResultsHandler(this.destination.getQueryResultsHandler(query, dataSource, knowledgeSource, eventListeners), this.deidConfig);
        }
        catch (EncryptionInitException ex) {
            throw new QueryResultsHandlerInitException("Error initializing deidentifier", ex);
        }
    }

    @Override
    public boolean isGetStatisticsSupported() {
        return this.destination.isGetStatisticsSupported();
    }

    @Override
    public Statistics getStatistics() throws StatisticsException {
        return this.destination.getStatistics();
    }

    @Override
    public String[] getSupportedPropositionIds(DataSource dataSource, KnowledgeSource knowledgeSource) throws GetSupportedPropositionIdsException {
        return this.destination.getSupportedPropositionIds(dataSource, knowledgeSource);
    }
}

