/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.arp.javautil.arrays.Arrays;
import org.drools.FactException;
import org.drools.StatefulSession;
import org.drools.event.WorkingMemoryEventListener;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.AbstractExecutionStrategy;
import org.protempa.AlgorithmSource;
import org.protempa.DeletedWorkingMemoryEventListener;
import org.protempa.ExecutionStrategyExecutionException;
import org.protempa.ExecutionStrategyInitializationException;
import org.protempa.ExecutionStrategyShutdownException;
import org.protempa.JBossRuleCreator;
import org.protempa.MarkDeletedPropositionVisitor;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.ProtempaException;
import org.protempa.ValidateAlgorithmCheckedVisitor;
import org.protempa.WorkingMemoryFactStore;
import org.protempa.datastore.WorkingMemoryDataStores;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

class StatefulExecutionStrategy
extends AbstractExecutionStrategy {
    private static final Logger LOGGER = Logger.getLogger(StatefulExecutionStrategy.class.getName());
    private final Path databasePath;
    private DataStore<String, WorkingMemoryFactStore> dataStore;
    private WorkingMemoryDataStores workingMemoryDataStores;
    private StatefulSession workingMemory;
    private final DeletedWorkingMemoryEventListener workingMemoryEventListener;
    private List<Proposition> propsToDelete;
    private final String databaseName;
    private final Path databaseDir;

    StatefulExecutionStrategy(AlgorithmSource algorithmSource, Query query) {
        super(algorithmSource, query);
        assert (query != null) : "query cannot be null";
        String dbPath = query.getDatabasePath();
        assert (dbPath != null) : "query.getDatabasePath() cannot return a null value";
        this.databasePath = Paths.get(dbPath, new String[0]);
        this.databaseDir = this.databasePath.getParent();
        this.databaseName = this.databasePath.getFileName().toString();
        this.workingMemoryEventListener = new DeletedWorkingMemoryEventListener();
        this.propsToDelete = new ArrayList<Proposition>();
    }

    @Override
    public void initialize(PropositionDefinitionCache cache) throws ExecutionStrategyInitializationException {
        this.createDataStoreManager(cache);
        super.initialize(cache);
        this.getOrCreateDataStore();
    }

    @Override
    public Iterator<Proposition> execute(String keyId, Iterator<? extends Proposition> objects) throws ExecutionStrategyExecutionException {
        this.getOrCreateWorkingMemoryInstance(keyId);
        this.updateWorkingMemory(keyId, objects);
        this.fireAllRules();
        this.cleanupAndPersistWorkingMemory(keyId);
        return this.getWorkingMemoryIterator();
    }

    @Override
    public void closeCurrentWorkingMemory() {
        this.workingMemory.dispose();
        this.propsToDelete = new ArrayList<Proposition>();
    }

    @Override
    public void shutdown() throws ExecutionStrategyShutdownException {
        ExecutionStrategyShutdownException exception1 = this.closeDataStore();
        ExecutionStrategyShutdownException exception2 = this.closeDataStoreManager();
        if (exception1 != null && exception2 != null) {
            exception1.addSuppressed(exception2);
            throw exception1;
        }
        if (exception1 != null) {
            throw exception1;
        }
        if (exception2 != null) {
            throw exception2;
        }
    }

    public DataStore<String, WorkingMemoryFactStore> getDataStore() {
        return this.dataStore;
    }

    @Override
    protected JBossRuleCreator newRuleCreator() throws ExecutionStrategyInitializationException {
        Collection<PropositionDefinition> propDefs;
        PropositionDefinitionCache cache;
        ValidateAlgorithmCheckedVisitor visitor = new ValidateAlgorithmCheckedVisitor(this.getAlgorithmSource());
        Query query = this.getQuery();
        switch (query.getQueryMode()) {
            case REPROCESS_RETRIEVE: {
                cache = new PropositionDefinitionCache(Collections.emptyList());
                propDefs = cache.getAll();
                break;
            }
            case REPROCESS_DELETE: {
                this.failIfQueriedPropIdIsNotAlreadyInDataStore(query);
                for (String pId : this.getQuery().getPropositionIds()) {
                    this.workingMemoryDataStores.getPropositionDefinitionsInStores().remove(pId);
                }
                cache = new PropositionDefinitionCache(Collections.emptyList());
                propDefs = cache.getAll();
                break;
            }
            case REPROCESS_UPDATE: {
                String pId;
                this.failIfQueriedPropIdIsNotAlreadyInDataStore(query);
                cache = this.getCache();
                ArrayList<PropositionDefinition> propDefsForCache = new ArrayList<PropositionDefinition>();
                LinkedList propIdsQueue = new LinkedList();
                Arrays.addAll(propIdsQueue, (Object[][])new String[][]{this.getQuery().getPropositionIds()});
                while ((pId = (String)propIdsQueue.poll()) != null) {
                    propDefsForCache.add(cache.get(pId));
                    for (PropositionDefinition propDef : cache.getAll()) {
                        Object[] children = propDef.getChildren();
                        if (!Arrays.contains((Object[])children, (Object)pId)) continue;
                        Arrays.addAll(propIdsQueue, (Object[][])new String[][]{children});
                    }
                }
                cache = new PropositionDefinitionCache(propDefsForCache);
                propDefs = cache.getAll();
                break;
            }
            case REPROCESS_CREATE: {
                this.failIfQueriedPropIdIsAlreadyInDataStore(query);
                cache = this.getCache();
                propDefs = new ArrayList<PropositionDefinition>(cache.getAll());
                cache = this.newCacheWithPropDefsThatWeNeedToCompute(propDefs);
                break;
            }
            case REPLACE: 
            case UPDATE: {
                cache = this.getCache();
                propDefs = cache.getAll();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected query mode " + (Object)((Object)query.getQueryMode())));
            }
        }
        try {
            visitor.visit(propDefs);
        }
        catch (ProtempaException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        JBossRuleCreator ruleCreator = new JBossRuleCreator(visitor.getAlgorithms(), this.getDerivationsBuilder(), cache);
        try {
            ruleCreator.visit(propDefs);
        }
        catch (ProtempaException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        return ruleCreator;
    }

    private PropositionDefinitionCache newCacheWithPropDefsThatWeNeedToCompute(Collection<PropositionDefinition> propDefs) {
        PropositionDefinitionCache dataStorePropDefs = this.workingMemoryDataStores.getPropositionDefinitionsInStores();
        Iterator<PropositionDefinition> itr = propDefs.iterator();
        while (itr.hasNext()) {
            PropositionDefinition propDef = itr.next();
            if (propDef != null && !dataStorePropDefs.contains(propDef.getPropositionId())) continue;
            itr.remove();
        }
        return new PropositionDefinitionCache(propDefs);
    }

    private void failIfQueriedPropIdIsAlreadyInDataStore(Query query) throws ExecutionStrategyInitializationException {
        PropositionDefinitionCache dataStorePropDefs = this.workingMemoryDataStores.getPropositionDefinitionsInStores();
        for (String propId : query.getPropositionIds()) {
            if (!dataStorePropDefs.contains(propId)) continue;
            throw new ExecutionStrategyInitializationException("Proposition id " + propId + " already exists; if you want to update it, use the update query mode");
        }
    }

    private void failIfQueriedPropIdIsNotAlreadyInDataStore(Query query) throws ExecutionStrategyInitializationException {
        PropositionDefinitionCache dataStorePropDefs = this.workingMemoryDataStores.getPropositionDefinitionsInStores();
        for (String propId : query.getPropositionIds()) {
            if (dataStorePropDefs.contains(propId)) continue;
            throw new ExecutionStrategyInitializationException("Proposition id " + propId + " not already in data store; use the add mode to add it");
        }
    }

    private void createDataStoreManager(PropositionDefinitionCache cache) throws ExecutionStrategyInitializationException {
        try {
            this.workingMemoryDataStores = new WorkingMemoryDataStores(this.databaseDir, this.databaseName, cache);
        }
        catch (IOException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
    }

    private void getOrCreateDataStore() throws ExecutionStrategyInitializationException {
        try {
            this.dataStore = this.workingMemoryDataStores.getDataStore();
            LOGGER.log(Level.FINE, "Opened data store {0}", this.databasePath.toString());
        }
        catch (IOException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        if (this.getQuery().getQueryMode() == QueryMode.REPLACE) {
            this.dataStore.clear();
            LOGGER.log(Level.FINE, "Cleared data store {0}", this.databasePath.toString());
        }
    }

    private void getOrCreateWorkingMemoryInstance(String keyId) {
        this.createWorkingMemory(keyId);
        this.workingMemory.addEventListener((WorkingMemoryEventListener)this.workingMemoryEventListener);
    }

    private void createWorkingMemory(String keyId) {
        Map<String, Integer> instanceNums;
        WorkingMemoryFactStore factStore;
        this.workingMemory = this.getRuleBase().newStatefulSession(true);
        this.workingMemory.setGlobal("keyId", (Object)keyId);
        if (this.dataStore != null && (factStore = (WorkingMemoryFactStore)this.dataStore.get((Object)keyId)) != null && (instanceNums = factStore.getInstanceNums()) != null) {
            this.workingMemory.setGlobal("derivedUniqueIdCounts", ((WorkingMemoryFactStore)this.dataStore.get((Object)keyId)).getInstanceNums());
        }
    }

    private void updateWorkingMemory(String keyId, Iterator<?> objects) throws FactException {
        if (objects != null) {
            while (objects.hasNext()) {
                this.workingMemory.insert((Object)((Proposition)objects.next()));
            }
        }
        if (this.dataStore != null) {
            WorkingMemoryFactStore factStore = (WorkingMemoryFactStore)this.dataStore.get((Object)keyId);
            QueryMode queryMode = this.getQuery().getQueryMode();
            switch (queryMode) {
                case REPROCESS_DELETE: 
                case REPROCESS_UPDATE: {
                    Collection<Proposition> result = factStore.getAll(this.getQuery().getPropositionIds());
                    new MarkDeletedPropositionVisitor().visit(result);
                    this.propsToDelete.addAll(result);
                }
                case REPROCESS_RETRIEVE: 
                case REPROCESS_CREATE: {
                    this.getDerivationsBuilder().reset(factStore.getForwardDerivations(), factStore.getBackwardDerivations());
                    for (Proposition prop : factStore.getPropositions()) {
                        if (prop.getDeleteDate() != null) continue;
                        this.workingMemory.insert((Object)prop);
                    }
                    break;
                }
                case REPLACE: 
                case UPDATE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected query mode " + (Object)((Object)queryMode)));
                }
            }
        }
    }

    private void fireAllRules() throws FactException {
        this.workingMemory.fireAllRules();
        this.propsToDelete.addAll(this.workingMemoryEventListener.getPropsToDelete());
    }

    private void cleanupAndPersistWorkingMemory(String keyId) throws ExecutionStrategyExecutionException {
        this.workingMemory.removeEventListener((WorkingMemoryEventListener)this.workingMemoryEventListener);
        this.workingMemoryEventListener.clear();
        LOGGER.log(Level.FINEST, "Persisting working memory for key ID {0}", keyId);
        WorkingMemoryFactStore factStore = new WorkingMemoryFactStore();
        HashSet<Proposition> realPropsToDelete = new HashSet<Proposition>(this.propsToDelete);
        HashMap<Proposition, Set<Proposition>> forwardDerivationsCopy = new HashMap<Proposition, Set<Proposition>>();
        for (Map.Entry<Proposition, Set<Proposition>> entry : this.getDerivationsBuilder().getForwardDerivations().entrySet()) {
            Proposition proposition = entry.getKey();
            Set<Proposition> values = entry.getValue();
            forwardDerivationsCopy.put(proposition, new HashSet<Proposition>(values));
        }
        HashMap<Proposition, Set<Proposition>> backwardsDerivationsCopy = new HashMap<Proposition, Set<Proposition>>();
        for (Map.Entry<Proposition, Set<Proposition>> entry : this.getDerivationsBuilder().getBackwardDerivations().entrySet()) {
            Proposition p = entry.getKey();
            Set<Proposition> values = entry.getValue();
            backwardsDerivationsCopy.put(p, new HashSet<Proposition>(values));
        }
        factStore.setForwardDerivations(forwardDerivationsCopy);
        factStore.setBackwardDerivations(backwardsDerivationsCopy);
        ArrayList<Proposition> arrayList = new ArrayList<Proposition>();
        Iterator iterator = this.workingMemory.iterateObjects();
        while (iterator.hasNext()) {
            Proposition prop = (Proposition)iterator.next();
            realPropsToDelete.remove(prop);
            arrayList.add(prop);
        }
        factStore.removeAll(realPropsToDelete);
        factStore.setPropositions(arrayList);
        factStore.setInstanceNums((Map)this.workingMemory.getGlobal("derivedUniqueIdCounts"));
        this.dataStore.put((Object)keyId, (Object)factStore);
        try {
            this.workingMemoryDataStores.finish();
        }
        catch (IOException ex) {
            throw new ExecutionStrategyExecutionException(ex);
        }
        LOGGER.log(Level.FINEST, "Persisted working memory for key ID {0}", keyId);
    }

    private Iterator<Proposition> getWorkingMemoryIterator() {
        return new IteratorChain(this.workingMemory.iterateObjects(), this.propsToDelete.iterator());
    }

    private ExecutionStrategyShutdownException closeDataStore() {
        if (this.dataStore != null) {
            try {
                this.dataStore.close();
            }
            catch (IOError err) {
                return new ExecutionStrategyShutdownException(err);
            }
        }
        return null;
    }

    private ExecutionStrategyShutdownException closeDataStoreManager() {
        try {
            this.workingMemoryDataStores.close();
        }
        catch (IOException ex) {
            return new ExecutionStrategyShutdownException(ex);
        }
        return null;
    }
}

