/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.key;

import java.util.List;
import org.protempa.DataSource;
import org.protempa.DataSourceReadException;
import org.protempa.KnowledgeSource;
import org.protempa.ProtempaEventListener;
import org.protempa.dest.AbstractDestination;
import org.protempa.dest.GetSupportedPropositionIdsException;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.key.KeySetQueryResultsHandler;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

public class KeySetDestination
extends AbstractDestination {
    private final String id;
    private final String displayName;

    public KeySetDestination() {
        this(null);
    }

    public KeySetDestination(String id) {
        this(id, null);
    }

    public KeySetDestination(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : super.getDisplayName();
    }

    @Override
    public String getId() {
        return this.id != null ? this.id : super.getId();
    }

    @Override
    public QueryResultsHandler getQueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource, List<? extends ProtempaEventListener> eventListeners) throws QueryResultsHandlerInitException {
        if (query.getQueryMode() == QueryMode.UPDATE) {
            throw new QueryResultsHandlerInitException("Update mode not supported");
        }
        return new KeySetQueryResultsHandler(dataSource, knowledgeSource, this.id, this.displayName);
    }

    @Override
    public String[] getSupportedPropositionIds(DataSource dataSource, KnowledgeSource knowledgeSource) throws GetSupportedPropositionIdsException {
        try {
            return new String[]{dataSource.getKeyType()};
        }
        catch (DataSourceReadException ex) {
            throw new GetSupportedPropositionIdsException(ex);
        }
    }
}

