/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.dest.table.RecordHandler;

class ListRecordHandler
extends RecordHandler<ArrayList<?>> {
    Logger logger = Logger.getLogger(ListRecordHandler.class.getName());
    private String inStatement = null;
    private Integer colCount = null;
    private boolean isParametersSet = true;

    ListRecordHandler(Connection connection, String statement) throws SQLException {
        super(connection, statement);
        this.inStatement = statement;
    }

    ListRecordHandler(Connection connection, String statement, boolean commit) throws SQLException {
        super(connection, statement, commit);
        this.inStatement = statement;
    }

    ListRecordHandler(ConnectionSpec connSpec, String statement) throws SQLException {
        super(connSpec, statement);
        this.inStatement = statement;
    }

    ListRecordHandler(ConnectionSpec connSpec, String statement, Integer colCount) throws SQLException {
        super(connSpec, statement, colCount);
        this.inStatement = statement;
        this.colCount = colCount;
    }

    @Override
    protected void setParameters(PreparedStatement statement, ArrayList<?> record) throws SQLException {
        int recSize = 0;
        this.logger.log(Level.FINEST, "Calculating Record Size");
        if (record instanceof List) {
            recSize = record.size();
        }
        this.logger.log(Level.FINEST, "Record Size:{0}", recSize);
        this.logger.log(Level.FINEST, "Number of Parameters:{0}", statement.getParameterMetaData().getParameterCount());
        if (statement.getParameterMetaData().getParameterCount() == recSize) {
            int n = record.size();
            for (int i = 0; i < n; ++i) {
                int pos = i + 1;
                statement.setString(pos, record.get(i) == null ? "NULL" : record.get(i).toString());
            }
            this.setParametersSet(true);
        } else {
            this.setParametersSet(false);
        }
    }

    public String getInStatement() {
        return this.inStatement;
    }

    public void setInStatement(String inStatement) {
        this.inStatement = inStatement;
    }

    @Override
    public void close() throws SQLException {
        this.logger.log(Level.FINER, "Closing by punting to super");
        super.close();
    }
}

