/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.sql.SQLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.dest.table.AbstractTabularWriter;
import org.protempa.dest.table.ListRecordHandler;
import org.protempa.dest.table.RecordHandler;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

public class RelDbTabularWriter
extends AbstractTabularWriter {
    private RecordHandler<ArrayList<?>> recordHandler;
    private final ArrayList<Object> row;
    private int colIndex;
    private String inStatement;
    private ConnectionSpec connectionSpec;
    private Map<String, RecordHandler<ArrayList<?>>> handlerList;
    private Map<String, String> statements;
    private Map<String, Integer> colCounts;
    private String tableName;
    Logger logger = Logger.getLogger(RelDbTabularWriter.class.getName());

    public RelDbTabularWriter(ConnectionSpec inConnectionSpec, String inStatement) throws SQLException {
        this.connectionSpec = inConnectionSpec;
        this.inStatement = inStatement;
        this.recordHandler = new ListRecordHandler(inConnectionSpec, inStatement);
        this.row = new ArrayList();
        this.logger.info("Creating RelDbTabularWriter");
    }

    public RelDbTabularWriter(ConnectionSpec inConnectionSpec, Map<String, String> inStatements) throws SQLException {
        this.connectionSpec = inConnectionSpec;
        this.statements = inStatements;
        this.handlerList = new HashMap();
        for (String tableName : inStatements.keySet()) {
            this.logger.info("Creating Handler: " + tableName + "; SQL: " + inStatements.get(tableName));
            this.handlerList.put(tableName, new ListRecordHandler(inConnectionSpec, inStatements.get(tableName)));
        }
        this.row = new ArrayList();
    }

    public RelDbTabularWriter(ConnectionSpec inConnectionSpec, Map<String, String> inStatements, Map<String, Integer> colCounts) throws SQLException {
        this.connectionSpec = inConnectionSpec;
        this.statements = inStatements;
        this.colCounts = colCounts;
        this.handlerList = new HashMap();
        for (String tableName : inStatements.keySet()) {
            this.logger.info("Creating Handler: " + tableName + "; SQL: " + inStatements.get(tableName));
            this.handlerList.put(tableName, new ListRecordHandler(inConnectionSpec, inStatements.get(tableName), colCounts.get(tableName)));
        }
        this.row = new ArrayList();
    }

    public RelDbTabularWriter(ConnectionSpec inConnectionSpec) throws SQLException {
        this.recordHandler = new ListRecordHandler(inConnectionSpec, this.inStatement);
        this.row = new ArrayList();
        this.logger.info("Creating RelDbTabularWriter");
    }

    public String getInStatement() {
        return this.inStatement;
    }

    public void setInStatement(String inStatement) throws SQLException {
        this.inStatement = inStatement;
        this.recordHandler.close();
        this.recordHandler = new ListRecordHandler(this.connectionSpec, inStatement);
    }

    public Map<String, String> getStatements() {
        return this.statements;
    }

    public void setStatements(Map<String, String> statements) {
        this.statements = statements;
    }

    public Map<String, Integer> getColCounts() {
        return this.colCounts;
    }

    public void setColCounts(Map<String, Integer> colCounts) {
        this.colCounts = colCounts;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public Map<String, RecordHandler<ArrayList<?>>> getHandlerList() {
        return this.handlerList;
    }

    public void setHandlerList(Map<String, RecordHandler<ArrayList<?>>> handlerList) {
        this.handlerList = handlerList;
    }

    public RecordHandler<ArrayList<?>> getRecordHandler() {
        return this.recordHandler;
    }

    public void setRecordHandler(RecordHandler<ArrayList<?>> recordHandler) {
        this.recordHandler = recordHandler;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void writeNominal(NominalValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getString());
        }
        this.incr();
    }

    @Override
    public void writeNumber(NumberValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getNumber());
        }
        this.incr();
    }

    @Override
    public void writeInequality(InequalityNumberValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inFormat.format((Object)inValue.getComparator()));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getComparator().getComparatorString());
        }
        this.incr();
    }

    @Override
    public void writeNumber(InequalityNumberValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getNumber());
        }
        this.incr();
    }

    @Override
    public void writeInequalityNumber(InequalityNumberValue inValue, Format inFormat) throws TabularWriterException {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getNumber());
        }
        this.incr();
    }

    @Override
    public void writeDate(DateValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getDate());
        }
        this.incr();
    }

    @Override
    public void writeBoolean(BooleanValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue == null ? "NULL" : inValue.getBoolean());
        }
        this.incr();
    }

    @Override
    public final void writeId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getId();
        this.writeString(value);
    }

    @Override
    public final void writeUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getStringRepresentation();
        this.writeString(value);
    }

    @Override
    public final void writeLocalUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getLocalUniqueId().getId();
        this.writeString(value);
    }

    @Override
    public final void writeNumericalId(Proposition inProposition) throws TabularWriterException {
        String value = String.valueOf(inProposition.getUniqueId().getLocalUniqueId().getNumericalId());
        this.writeString(value);
    }

    @Override
    public final void writeStart(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat == null ? inProposition.getStartFormattedShort() : inProposition.formatStart(inFormat);
        this.writeString(value);
    }

    @Override
    public final void writeFinish(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat == null ? inProposition.getFinishFormattedShort() : inProposition.formatFinish(inFormat);
        this.writeString(value);
    }

    @Override
    public final void writeLength(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat == null ? inProposition.getLengthFormattedShort() : inProposition.formatLength(inFormat);
        this.writeString(value);
    }

    @Override
    public final void writeParameterValue(Parameter inProposition, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getValue();
        this.writeValue(value, inFormat);
    }

    @Override
    public final void writePropertyValue(Proposition inProposition, String inPropertyName, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getProperty(inPropertyName);
        this.writeValue(value, inFormat);
    }

    @Override
    public final void writeNull() throws TabularWriterException {
        NominalValue value = new NominalValue("NULL");
        this.writeValue(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void newRow() throws TabularWriterException {
        StringBuilder sb;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Statement:" + this.inStatement);
            StringBuilder sb2 = new StringBuilder();
            for (Object o : this.row) {
                sb2.append(o.toString() + ":");
            }
            this.logger.finest("Row:" + sb2.toString());
        }
        try {
            if (this.recordHandler != null) {
                this.logger.finest("Have RECORDHANDLER for table:  " + this.tableName);
                this.recordHandler.insert(this.row);
            } else {
                this.logger.finest("Getting RECORDHANDLER for table:  " + this.tableName);
                this.recordHandler = this.handlerList.get(this.tableName);
                if (this.recordHandler != null) {
                    this.recordHandler.insert(this.row);
                } else {
                    this.logger.finest("NULL RECORDHANDLER for table:" + this.tableName + "; Getting from statements map " + (this.statements == null ? 0 : this.statements.size()));
                    this.inStatement = this.statements.get(this.tableName);
                    this.logger.finest("Got Statement:" + this.inStatement);
                    this.recordHandler = new ListRecordHandler(this.connectionSpec, this.inStatement);
                    if (this.handlerList.containsKey(this.tableName)) {
                        this.handlerList.replace(this.tableName, this.recordHandler);
                    } else {
                        this.handlerList.put(this.tableName, this.recordHandler);
                    }
                    this.recordHandler.insert(this.row);
                }
            }
        }
        catch (SQLException e) {
            sb = new StringBuilder();
            for (Object o : this.row) {
                sb.append(o.toString() + ":");
            }
            this.logger.warning("SQLException table:" + this.tableName + "::" + sb.toString());
        }
        catch (NullPointerException ex) {
            sb = new StringBuilder();
            for (Object o : this.row) {
                sb.append(o.toString() + ":");
            }
            this.logger.warning("NullPointerException for table:" + this.tableName + "::" + sb.toString());
        }
        finally {
            this.row.clear();
            this.colIndex = 0;
        }
    }

    @Override
    public final void close() throws TabularWriterException {
        try {
            this.logger.log(Level.FINEST, "CLOSING recordHandler: {0}", this.recordHandler.getClass().getName());
            if (this.recordHandler != null) {
                this.recordHandler.close();
            }
            if (this.handlerList != null && this.handlerList.size() > 0) {
                this.logger.log(Level.FINEST, "Dealing with handlers in list: {0}", this.handlerList.size());
                for (String tableName : this.getHandlerList().keySet()) {
                    this.handlerList.get(tableName).close();
                }
            }
        }
        catch (SQLException ex) {
            throw new TabularWriterException(ex);
        }
    }

    private int incr() {
        return this.colIndex++;
    }

    private void writeString(String inValue) throws TabularWriterException {
        this.row.add(inValue == null ? "NULL" : inValue);
        this.incr();
    }
}

