/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.query.QueryMode;

public class Query
implements Serializable {
    public static QueryMode DEFAULT_QUERY_MODE = QueryMode.REPLACE;
    private static final long serialVersionUID = -9007995369064299652L;
    private static final PropositionDefinition[] EMPTY_PROP_DEF_ARRAY = new PropositionDefinition[0];
    private final String[] keyIds;
    private final Filter filters;
    private final String[] propIds;
    private final PropositionDefinition[] propDefs;
    private String name;
    private String username;
    private QueryMode queryMode;
    private String databasePath;

    public Query(String[] keyIds, Filter filters, String[] propIds, PropositionDefinition[] propDefs, QueryMode queryMode) {
        this(null, keyIds, filters, propIds, propDefs, queryMode);
    }

    public Query(String id, String[] keyIds, Filter filters, String[] propIds, PropositionDefinition[] propDefs, QueryMode queryMode) {
        this(id, null, keyIds, filters, propIds, propDefs, queryMode);
    }

    public Query(String id, String username, String[] keyIds, Filter filters, String[] propIds, PropositionDefinition[] propDefs, QueryMode queryMode) {
        this(id, username, keyIds, filters, propIds, propDefs, queryMode, null);
    }

    public Query(String id, String username, String[] keyIds, Filter filters, String[] propIds, PropositionDefinition[] propDefs, QueryMode queryMode, String databasePath) {
        if (keyIds == null) {
            keyIds = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (propIds == null) {
            propIds = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (propDefs == null) {
            propDefs = EMPTY_PROP_DEF_ARRAY;
        }
        ProtempaUtil.checkArrayForNullElement(keyIds, "keyIds");
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        ProtempaUtil.checkArrayForNullElement(propDefs, "propDefs");
        this.keyIds = (String[])keyIds.clone();
        this.filters = filters;
        this.propIds = (String[])propIds.clone();
        ProtempaUtil.internAll(this.propIds);
        this.propDefs = (PropositionDefinition[])propDefs.clone();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        this.name = id;
        this.queryMode = queryMode == null ? DEFAULT_QUERY_MODE : queryMode;
        this.username = username;
        this.databasePath = databasePath;
        if (this.databasePath == null && org.arp.javautil.arrays.Arrays.contains((Object[])QueryMode.reprocessModes(), (Object)((Object)this.queryMode))) {
            throw new IllegalArgumentException("Must specify a database path when in reprocess mode!");
        }
    }

    public final Filter getFilters() {
        return this.filters;
    }

    public final String[] getKeyIds() {
        return (String[])this.keyIds.clone();
    }

    public final String[] getPropositionIds() {
        return (String[])this.propIds.clone();
    }

    public final PropositionDefinition[] getPropositionDefinitions() {
        return (PropositionDefinition[])this.propDefs.clone();
    }

    public final String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    Filter[] getFiltersArray() {
        if (this.filters == null) {
            return new Filter[0];
        }
        return this.filters.filterChainToArray();
    }

    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.filters != null ? this.filters.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.keyIds);
        result = 31 * result + Arrays.hashCode(this.propIds);
        result = 31 * result + Arrays.hashCode(this.propDefs);
        result = 31 * result + this.queryMode.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.databasePath != null ? this.databasePath.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        if (!Arrays.equals(this.keyIds, other.keyIds)) {
            return false;
        }
        if (!Arrays.equals(this.propIds, other.propIds)) {
            return false;
        }
        if (!Arrays.equals(this.propDefs, other.propDefs)) {
            return false;
        }
        if (!this.queryMode.equals((Object)other.queryMode)) {
            return false;
        }
        if (this.username != null ? !this.username.equals(other.username) : other.username != null) {
            return false;
        }
        return !(this.databasePath != null ? this.databasePath.equals(other.databasePath) : other.databasePath != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

