/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.event.ServerProjectListener;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectSessionClosedEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.Server_Test;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.LockStepper;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

public class ServerAdmin_Test
extends APITestCase {
    private static Logger log = Log.getLogger(ServerAdmin_Test.class);
    private RemoteServer server;
    public static final String HOST = "localhost";
    public static final String NAME = "//localhost/" + Server.getBoundName();
    public static final String PROJECT_NAME = "Newspaper";
    public static final String USER1 = "Ray Fergerson";
    public static final String PASSWORD1 = "claudia";
    public static final String USER2 = "Jennifer Vendetti";
    public static final String PASSWORD2 = "jenny";
    public static final String USER3 = "Admin";
    public static final String PASSWORD3 = "admin";

    public void setUp() throws Exception {
        super.setUp();
        try {
            if (!Server_Test.startServer()) {
                return;
            }
            this.server = (RemoteServer)Naming.lookup(NAME);
            this.server.reinitialize();
        }
        catch (NotBoundException notBoundException) {
            ServerAdmin_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
    }

    public DefaultKnowledgeBase getKb() {
        RemoteProjectManager remoteProjectManager = RemoteProjectManager.getInstance();
        Project project = remoteProjectManager.getProject(HOST, USER1, PASSWORD1, PROJECT_NAME, true);
        return (DefaultKnowledgeBase)project.getKnowledgeBase();
    }

    public RemoteSession openSession() throws RemoteException {
        return this.server.openSession(USER2, SystemUtilities.getMachineIpAddress(), PASSWORD2);
    }

    public RemoteSession openAdminSession() throws RemoteException {
        return this.server.openSession(USER3, SystemUtilities.getMachineIpAddress(), PASSWORD3);
    }

    public void testSetProjectStatus() throws RemoteException {
        final LockStepper<TestSetProjectStatusStages> lockStepper = new LockStepper<TestSetProjectStatusStages>(TestSetProjectStatusStages.STARTED);
        new Thread("Listening for project status changes thread"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = ServerAdmin_Test.this.getKb();
                    TestSetProjectStatusListener testSetProjectStatusListener = new TestSetProjectStatusListener();
                    defaultKnowledgeBase.addServerProjectListener(testSetProjectStatusListener);
                    defaultKnowledgeBase.flushEvents();
                    Assert.assertFalse((boolean)testSetProjectStatusListener.isStatusChanged());
                    lockStepper.stageAchieved(TestSetProjectStatusStages.LISTENING, null);
                    lockStepper.waitForStage(TestSetProjectStatusStages.STATUS_CHANGED);
                    defaultKnowledgeBase.flushEvents();
                    Assert.assertTrue((boolean)testSetProjectStatusListener.isStatusChanged());
                    Assert.assertTrue((testSetProjectStatusListener.getNewStatus() == ServerProject.ProjectStatus.SHUTTING_DOWN ? 1 : 0) != 0);
                    defaultKnowledgeBase.dispose();
                    lockStepper.stageAchieved(TestSetProjectStatusStages.DONE, null);
                }
                catch (Throwable throwable) {
                    lockStepper.exceptionOffMainThread(TestSetProjectStatusStages.DONE, throwable);
                }
            }
        }.start();
        lockStepper.waitForStage(TestSetProjectStatusStages.LISTENING);
        RemoteSession remoteSession = this.openSession();
        this.server.setProjectStatus(PROJECT_NAME, ServerProject.ProjectStatus.SHUTTING_DOWN, remoteSession);
        lockStepper.stageAchieved(TestSetProjectStatusStages.STATUS_CHANGED, null);
        lockStepper.waitForStage(TestSetProjectStatusStages.DONE);
    }

    public void testNotification() throws RemoteException {
        final LockStepper<TestNotificationStages> lockStepper = new LockStepper<TestNotificationStages>(TestNotificationStages.STARTED);
        new Thread("Listening for project notification thread"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = ServerAdmin_Test.this.getKb();
                    TestNotificationListener testNotificationListener = new TestNotificationListener();
                    defaultKnowledgeBase.addServerProjectListener(testNotificationListener);
                    Assert.assertFalse((boolean)testNotificationListener.isNotified());
                    lockStepper.stageAchieved(TestNotificationStages.LISTENING, null);
                    lockStepper.waitForStage(TestNotificationStages.NOTIFIED);
                    defaultKnowledgeBase.flushEvents();
                    Assert.assertTrue((boolean)testNotificationListener.isNotified());
                    Assert.assertTrue((boolean)testNotificationListener.getMessage().equals("hello world"));
                    defaultKnowledgeBase.dispose();
                    lockStepper.stageAchieved(TestNotificationStages.DONE, null);
                }
                catch (Throwable throwable) {
                    lockStepper.exceptionOffMainThread(TestNotificationStages.DONE, throwable);
                }
            }
        }.start();
        lockStepper.waitForStage(TestNotificationStages.LISTENING);
        RemoteSession remoteSession = this.openSession();
        this.server.notifyProject(PROJECT_NAME, "hello world", remoteSession);
        lockStepper.stageAchieved(TestNotificationStages.NOTIFIED, null);
        lockStepper.waitForStage(TestNotificationStages.DONE);
    }

    public void testSingleProjectShutdown() throws RemoteException {
        final LockStepper<TestSingleProjectShutdownStages> lockStepper = new LockStepper<TestSingleProjectShutdownStages>(TestSingleProjectShutdownStages.START);
        new Thread("Is the Project Alive Thread"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = ServerAdmin_Test.this.getKb();
                    int n = defaultKnowledgeBase.getFrames().size();
                    defaultKnowledgeBase.flushCache();
                    lockStepper.stageAchieved(TestSingleProjectShutdownStages.OPENED, null);
                    lockStepper.waitForStage(TestSingleProjectShutdownStages.KILLED_PROJECT);
                    boolean bl = false;
                    try {
                        defaultKnowledgeBase.getFrame("Article");
                    }
                    catch (Throwable throwable) {
                        bl = true;
                    }
                    Assert.assertTrue((boolean)bl);
                    bl = false;
                    try {
                        defaultKnowledgeBase = ServerAdmin_Test.this.getKb();
                        defaultKnowledgeBase.getFrames();
                    }
                    catch (Throwable throwable) {
                        bl = true;
                    }
                    Assert.assertTrue((boolean)bl);
                    lockStepper.stageAchieved(TestSingleProjectShutdownStages.OK_DEAD, null);
                    lockStepper.waitForStage(TestSingleProjectShutdownStages.REVIVED);
                    defaultKnowledgeBase = ServerAdmin_Test.this.getKb();
                    Assert.assertTrue((defaultKnowledgeBase.getFrames().size() == n ? 1 : 0) != 0);
                    lockStepper.stageAchieved(TestSingleProjectShutdownStages.DONE, null);
                }
                catch (Throwable throwable) {
                    log.log(Level.WARNING, "Exception will cause junit to fail", throwable);
                    lockStepper.exceptionOffMainThread(TestSingleProjectShutdownStages.DONE, throwable);
                }
            }
        }.start();
        lockStepper.waitForStage(TestSingleProjectShutdownStages.OPENED);
        RemoteSession remoteSession = this.openAdminSession();
        this.server.shutdown(PROJECT_NAME, remoteSession);
        SystemUtilities.sleepMsec(200);
        lockStepper.stageAchieved(TestSingleProjectShutdownStages.KILLED_PROJECT, null);
        lockStepper.waitForStage(TestSingleProjectShutdownStages.OK_DEAD);
        this.server.setProjectStatus(PROJECT_NAME, ServerProject.ProjectStatus.READY, remoteSession);
        lockStepper.stageAchieved(TestSingleProjectShutdownStages.REVIVED, null);
        lockStepper.waitForStage(TestSingleProjectShutdownStages.DONE);
    }

    public void testKillOtherUser() throws RemoteException {
        final LockStepper<TestKillOtherUser> lockStepper = new LockStepper<TestKillOtherUser>(TestKillOtherUser.START);
        new Thread(){

            public void run() {
                try {
                    RemoteSession remoteSession = ServerAdmin_Test.this.server.openSession(ServerAdmin_Test.USER1, SystemUtilities.getMachineIpAddress(), ServerAdmin_Test.PASSWORD1);
                    RemoteServerProject remoteServerProject = ServerAdmin_Test.this.server.openProject(ServerAdmin_Test.PROJECT_NAME, remoteSession);
                    Project project = RemoteClientProject.createProject(ServerAdmin_Test.this.server, remoteServerProject, remoteSession, false);
                    KnowledgeBase knowledgeBase = project.getKnowledgeBase();
                    knowledgeBase.flushCache();
                    knowledgeBase.getFrames();
                    knowledgeBase.flushCache();
                    lockStepper.stageAchieved(TestKillOtherUser.OPEN, remoteSession);
                    lockStepper.waitForStage(TestKillOtherUser.MURDER);
                    boolean bl = false;
                    Thread.sleep(6000L);
                    try {
                        knowledgeBase.getFrames();
                    }
                    catch (Throwable throwable) {
                        bl = true;
                    }
                    Assert.assertTrue((boolean)bl);
                    remoteServerProject = ServerAdmin_Test.this.server.openProject(ServerAdmin_Test.PROJECT_NAME, remoteSession);
                    Assert.assertTrue((remoteServerProject == null ? 1 : 0) != 0);
                    lockStepper.stageAchieved(TestKillOtherUser.CONFIRMED, null);
                }
                catch (Throwable throwable) {
                    log.log(Level.SEVERE, throwable.getMessage(), throwable);
                    lockStepper.exceptionOffMainThread(TestKillOtherUser.CONFIRMED, throwable);
                }
            }
        }.start();
        RemoteSession remoteSession = this.openAdminSession();
        RemoteSession remoteSession2 = (RemoteSession)lockStepper.waitForStage(TestKillOtherUser.OPEN);
        this.server.killOtherUserSession(remoteSession2, remoteSession);
        lockStepper.stageAchieved(TestKillOtherUser.MURDER, null);
        lockStepper.waitForStage(TestKillOtherUser.CONFIRMED);
    }

    public void testKillOtherUserPreventedByPolicy() throws RemoteException {
        final LockStepper<TestKillOtherUser> lockStepper = new LockStepper<TestKillOtherUser>(TestKillOtherUser.START);
        new Thread(){

            public void run() {
                try {
                    RemoteSession remoteSession = ServerAdmin_Test.this.server.openSession(ServerAdmin_Test.USER1, SystemUtilities.getMachineIpAddress(), ServerAdmin_Test.PASSWORD1);
                    RemoteServerProject remoteServerProject = ServerAdmin_Test.this.server.openProject(ServerAdmin_Test.PROJECT_NAME, remoteSession);
                    Project project = RemoteClientProject.createProject(ServerAdmin_Test.this.server, remoteServerProject, remoteSession, false);
                    KnowledgeBase knowledgeBase = project.getKnowledgeBase();
                    knowledgeBase.flushCache();
                    knowledgeBase.getFrames();
                    knowledgeBase.flushCache();
                    lockStepper.stageAchieved(TestKillOtherUser.OPEN, remoteSession);
                    lockStepper.waitForStage(TestKillOtherUser.MURDER);
                    boolean bl = false;
                    Thread.sleep(6000L);
                    try {
                        knowledgeBase.getFrames();
                    }
                    catch (Throwable throwable) {
                        bl = true;
                    }
                    Assert.assertTrue((!bl ? 1 : 0) != 0);
                    lockStepper.stageAchieved(TestKillOtherUser.CONFIRMED, null);
                }
                catch (Throwable throwable) {
                    lockStepper.exceptionOffMainThread(TestKillOtherUser.CONFIRMED, throwable);
                }
            }
        }.start();
        RemoteSession remoteSession = this.openSession();
        RemoteSession remoteSession2 = (RemoteSession)lockStepper.waitForStage(TestKillOtherUser.OPEN);
        this.server.killOtherUserSession(remoteSession2, remoteSession);
        lockStepper.stageAchieved(TestKillOtherUser.MURDER, null);
        lockStepper.waitForStage(TestKillOtherUser.CONFIRMED);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestKillOtherUser {
        START,
        OPEN,
        MURDER,
        CONFIRMED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestSingleProjectShutdownStages {
        START,
        OPENED,
        KILLED_PROJECT,
        OK_DEAD,
        REVIVED,
        DONE;

    }

    private class TestNotificationListener
    implements ServerProjectListener {
        private boolean notified = false;
        private String message;

        private TestNotificationListener() {
        }

        public void projectNotificationReceived(ServerProjectNotificationEvent serverProjectNotificationEvent) {
            this.notified = true;
            this.message = serverProjectNotificationEvent.getMessage();
        }

        public void projectStatusChanged(ServerProjectStatusChangeEvent serverProjectStatusChangeEvent) {
        }

        public void beforeProjectSessionClosed(ServerProjectSessionClosedEvent serverProjectSessionClosedEvent) {
        }

        public boolean isNotified() {
            return this.notified;
        }

        public String getMessage() {
            return this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestNotificationStages {
        STARTED,
        LISTENING,
        NOTIFIED,
        DONE;

    }

    private class TestSetProjectStatusListener
    implements ServerProjectListener {
        private boolean statusChanged = false;
        private ServerProject.ProjectStatus oldStatus;
        private ServerProject.ProjectStatus newStatus;

        private TestSetProjectStatusListener() {
        }

        public void projectNotificationReceived(ServerProjectNotificationEvent serverProjectNotificationEvent) {
        }

        public void projectStatusChanged(ServerProjectStatusChangeEvent serverProjectStatusChangeEvent) {
            this.statusChanged = true;
            this.oldStatus = serverProjectStatusChangeEvent.getOldStatus();
            this.newStatus = serverProjectStatusChangeEvent.getNewStatus();
        }

        public void beforeProjectSessionClosed(ServerProjectSessionClosedEvent serverProjectSessionClosedEvent) {
        }

        public boolean isStatusChanged() {
            return this.statusChanged;
        }

        public ServerProject.ProjectStatus getOldStatus() {
            return this.oldStatus;
        }

        public ServerProject.ProjectStatus getNewStatus() {
            return this.newStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestSetProjectStatusStages {
        STARTED,
        LISTENING,
        STATUS_CHANGED,
        DONE;

    }
}

